/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.util.ObjectHelper;

public final class ThreadHelper {
    public static final String DEFAULT_PATTERN = "Camel Thread ${counter} - ${name}";
    private static AtomicLong threadCounter = new AtomicLong();

    private ThreadHelper() {
    }

    private static long nextThreadCounter() {
        return threadCounter.getAndIncrement();
    }

    public static String resolveThreadName(String pattern, String name) {
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        if (name.indexOf("$") > -1) {
            name = name.replaceAll("\\$", "CAMEL_REPLACE_ME");
        }
        String longName = name;
        String shortName = name.contains("?") ? ObjectHelper.before(name, "?") : name;
        String answer = pattern.replaceFirst("\\$\\{counter\\}", "" + ThreadHelper.nextThreadCounter());
        answer = answer.replaceFirst("\\$\\{longName\\}", longName);
        if ((answer = answer.replaceFirst("\\$\\{name\\}", shortName)).indexOf("$") > -1 || answer.indexOf("${") > -1 || answer.indexOf("}") > -1) {
            throw new IllegalArgumentException("Pattern is invalid: " + pattern);
        }
        if (answer.indexOf("CAMEL_REPLACE_ME") > -1) {
            answer = answer.replaceAll("CAMEL_REPLACE_ME", "\\$");
        }
        return answer;
    }
}

