/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.util.ObjectHelper;

public class NodeData {
    public String id;
    public String image;
    public String label;
    public String shape;
    public String edgeLabel;
    public String tooltop;
    public String nodeType;
    public boolean nodeWritten;
    public String url;
    public List<ProcessorDefinition> outputs;
    public String association = "property";

    public NodeData(String id, Object node, String imagePrefix) {
        ProcessorDefinition processorType;
        this.id = id;
        if (node instanceof ProcessorDefinition) {
            processorType = (ProcessorDefinition)node;
            this.edgeLabel = processorType.getLabel();
        }
        if (node instanceof FromDefinition) {
            FromDefinition fromType = (FromDefinition)node;
            this.tooltop = fromType.getLabel();
            this.label = this.removeQueryString(this.tooltop);
            this.url = "http://camel.apache.org/message-endpoint.html";
        } else if (node instanceof ToDefinition) {
            ToDefinition toType = (ToDefinition)node;
            this.tooltop = toType.getLabel();
            this.label = this.removeQueryString(this.tooltop);
            this.edgeLabel = "";
            this.url = "http://camel.apache.org/message-endpoint.html";
        } else if (node instanceof FilterDefinition) {
            this.image = imagePrefix + "MessageFilterIcon.png";
            this.label = "Filter";
            this.nodeType = "Message Filter";
        } else if (node instanceof WhenDefinition) {
            this.image = imagePrefix + "MessageFilterIcon.png";
            this.nodeType = "When Filter";
            this.label = "When";
            this.url = "http://camel.apache.org/content-based-router.html";
        } else if (node instanceof OtherwiseDefinition) {
            this.nodeType = "Otherwise";
            this.edgeLabel = "";
            this.url = "http://camel.apache.org/content-based-router.html";
            this.tooltop = "Otherwise";
        } else if (node instanceof ChoiceDefinition) {
            this.image = imagePrefix + "ContentBasedRouterIcon.png";
            this.nodeType = "Content Based Router";
            this.label = "Choice";
            this.edgeLabel = "";
            ChoiceDefinition choice = (ChoiceDefinition)node;
            ArrayList<WhenDefinition> outputs = new ArrayList<WhenDefinition>(choice.getWhenClauses());
            if (choice.getOtherwise() != null) {
                outputs.add((WhenDefinition)((Object)choice.getOtherwise()));
            }
            this.outputs = outputs;
        } else if (node instanceof RecipientListDefinition) {
            this.image = imagePrefix + "RecipientListIcon.png";
            this.nodeType = "Recipient List";
        } else if (node instanceof RoutingSlipDefinition) {
            this.image = imagePrefix + "RoutingTableIcon.png";
            this.nodeType = "Routing Slip";
            this.url = "http://camel.apache.org/routing-slip.html";
        } else if (node instanceof SplitDefinition) {
            this.image = imagePrefix + "SplitterIcon.png";
            this.nodeType = "Splitter";
        } else if (node instanceof AggregateDefinition) {
            this.image = imagePrefix + "AggregatorIcon.png";
            this.nodeType = "Aggregator";
        } else if (node instanceof ResequenceDefinition) {
            this.image = imagePrefix + "ResequencerIcon.png";
            this.nodeType = "Resequencer";
        } else if (node instanceof BeanDefinition) {
            BeanDefinition beanRef = (BeanDefinition)node;
            this.nodeType = "Bean Ref";
            this.label = beanRef.getLabel() + " Bean";
            this.shape = "box";
        }
        if (ObjectHelper.isEmpty(this.nodeType) && node != null) {
            String name = node.getClass().getName();
            int idx = name.lastIndexOf(46);
            if (idx > 0) {
                name = name.substring(idx + 1);
            }
            if (name.endsWith("Type")) {
                name = name.substring(0, name.length() - 4);
            }
            this.nodeType = NodeData.insertSpacesBetweenCamelCase(name);
        }
        if (this.label == null) {
            if (ObjectHelper.isEmpty(this.image)) {
                this.label = this.nodeType;
                this.shape = "box";
            } else {
                this.label = ObjectHelper.isNotEmpty(this.edgeLabel) ? "" : node.toString();
            }
        }
        if (ObjectHelper.isEmpty(this.tooltop)) {
            if (ObjectHelper.isNotEmpty(this.nodeType)) {
                String description = ObjectHelper.isNotEmpty(this.edgeLabel) ? this.edgeLabel : this.label;
                this.tooltop = this.nodeType + ": " + description;
            } else {
                this.tooltop = this.label;
            }
        }
        if (ObjectHelper.isEmpty(this.url) && ObjectHelper.isNotEmpty(this.nodeType)) {
            this.url = "http://camel.apache.org/" + this.nodeType.toLowerCase(Locale.ENGLISH).replace(' ', '-') + ".html";
        }
        if (node instanceof ProcessorDefinition && this.outputs == null) {
            processorType = (ProcessorDefinition)node;
            this.outputs = processorType.getOutputs();
        }
    }

    protected String removeQueryString(String text) {
        int idx = text.indexOf(63);
        if (idx <= 0) {
            return text;
        }
        return text.substring(0, idx);
    }

    public static String insertSpacesBetweenCamelCase(String name) {
        boolean lastCharacterLowerCase = false;
        StringBuilder buffer = new StringBuilder();
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (lastCharacterLowerCase) {
                    buffer.append(' ');
                }
                lastCharacterLowerCase = false;
            } else {
                lastCharacterLowerCase = true;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

