/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.fusesource.fabric.stream.log.HttpSimulator;
import org.fusesource.fabric.stream.log.InputBatcher;
import org.fusesource.fabric.stream.log.SnappyCompressor;

public class Main {
    String broker;
    String destination;
    int batchSize = 65536;
    long batchTimeout = 5000L;
    boolean compress = false;

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        LinkedList<String> argl = new LinkedList<String>(Arrays.asList(args));
        while (!argl.isEmpty()) {
            try {
                String arg = argl.removeFirst();
                if ("--help".equals(arg)) {
                    Main.displayHelpAndExit(0);
                    continue;
                }
                if ("--broker".equals(arg)) {
                    main.broker = Main.shift(argl);
                    continue;
                }
                if ("--destination".equals(arg)) {
                    main.destination = Main.shift(argl);
                    continue;
                }
                if ("--batch-size".equals(arg)) {
                    main.batchSize = Integer.parseInt(Main.shift(argl));
                    continue;
                }
                if ("--batch-timeout".equals(arg)) {
                    main.batchTimeout = Long.parseLong(Main.shift(argl));
                    continue;
                }
                if ("--compress".equals(arg)) {
                    main.compress = Boolean.parseBoolean(Main.shift(argl));
                    continue;
                }
                System.err.println("Invalid usage: unknown option: " + arg);
                Main.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid usage: argument not a number");
                Main.displayHelpAndExit(1);
            }
        }
        if (main.broker == null) {
            System.err.println("Invalid usage: --broker option not specified.");
            Main.displayHelpAndExit(1);
        }
        if (main.destination == null) {
            System.err.println("Invalid usage: --destination option not specified.");
            Main.displayHelpAndExit(1);
        }
        main.execute();
        System.exit(0);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            System.err.println("Invalid usage: Missing argument");
            Main.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    private static void displayHelpAndExit(int exitCode) {
        Main.displayResourceFile("main-usage.txt");
        System.exit(exitCode);
    }

    private void execute() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.disableJMX();
        context.addComponent("activemq", ActiveMQComponent.activeMQComponent(this.broker));
        final InputBatcher batcher = new InputBatcher();
        batcher.setBatchSize(this.batchSize);
        batcher.setBatchTimeout(this.batchTimeout);
        context.addComponent("batcher", batcher);
        context.addRoutes(new RouteBuilder(){

            @Override
            public void configure() throws Exception {
                Endpoint source = batcher.createEndpoint("stdin");
                RouteDefinition route = this.from(source);
                if (Main.this.compress) {
                    route = (RouteDefinition)route.process(new SnappyCompressor());
                }
                route.to("activemq:" + Main.this.destination);
            }
        });
        context.start();
        Main main = this;
        synchronized (main) {
            while (true) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displayResourceFile(String name) {
        InputStream is = HttpSimulator.class.getResourceAsStream(name);
        try {
            int c;
            while ((c = is.read()) >= 0) {
                System.out.write(c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

