/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring.security3;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasypt.commons.CommonUtils;
import org.jasypt.digest.StringDigester;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;

public final class TokenBasedRememberMeServices
extends AbstractRememberMeServices {
    private StringDigester digester = null;

    public void setDigester(StringDigester digester) {
        this.digester = digester;
    }

    private String getSignatureData(long tokenExpiryTime, String username, String password) {
        return username + ":" + tokenExpiryTime + ":" + password + ":" + this.getKey();
    }

    protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        String password;
        if (this.digester == null) {
            throw new IllegalStateException("Service incorrectly initialized: a digester has not been set. A value must be specified for the \"digester\" property in service of class " + ((Object)((Object)this)).getClass().getName());
        }
        if (cookieTokens.length != 3) {
            throw new InvalidCookieException("Wrong number of tokens in cookie");
        }
        String usernameToken = cookieTokens[0];
        String expiryToken = cookieTokens[1];
        String digestedSignature = cookieTokens[2];
        long expiryTimestamp = -1L;
        try {
            expiryTimestamp = new Long(expiryToken);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidCookieException("Invalid cookie expiry token");
        }
        if (expiryTimestamp < System.currentTimeMillis()) {
            throw new InvalidCookieException("Cookie has expired (expired on '" + new Date(expiryTimestamp) + "'; current time is '" + new Date() + "')");
        }
        UserDetails userDetails = this.getUserDetailsService().loadUserByUsername(usernameToken);
        String username = userDetails.getUsername();
        if (!this.digester.matches(this.getSignatureData(expiryTimestamp, username, password = userDetails.getPassword()), digestedSignature)) {
            throw new InvalidCookieException("Cookie signature is not valid");
        }
        return userDetails;
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (this.digester == null) {
            throw new IllegalStateException("Service incorrectly initialized: a digester has not been set. A value must be specified for the \"digester\" property in service of class " + ((Object)((Object)this)).getClass().getName());
        }
        String username = null;
        String password = null;
        if (successfulAuthentication.getPrincipal() instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)successfulAuthentication.getPrincipal();
            username = userDetails.getUsername();
            password = userDetails.getPassword();
        } else {
            username = successfulAuthentication.getPrincipal().toString();
            String string = password = successfulAuthentication.getCredentials() == null ? null : successfulAuthentication.getCredentials().toString();
        }
        if (CommonUtils.isEmpty(username) || CommonUtils.isEmpty(password)) {
            return;
        }
        int tokenValiditySeconds = this.getTokenValiditySeconds();
        long expiryTime = System.currentTimeMillis() + 1000L * (long)(tokenValiditySeconds < 0 ? 1209600 : tokenValiditySeconds);
        String signature = this.digester.digest(this.getSignatureData(expiryTime, username, password));
        this.setCookie(new String[]{username, Long.toString(expiryTime), signature}, tokenValiditySeconds, request, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added remember-me cookie for user '" + username + "', expiry: '" + new Date(expiryTime) + "'");
        }
    }
}

