/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public class ErrorHandlerBuilderRef
extends ErrorHandlerBuilderSupport {
    public static final String DEFAULT_ERROR_HANDLER_BUILDER = "CamelDefaultErrorHandlerBuilder";
    private final String ref;
    private final Map<RouteContext, ErrorHandlerBuilder> handlers = new HashMap<RouteContext, ErrorHandlerBuilder>();
    private boolean supportTransacted;

    public ErrorHandlerBuilderRef(String ref) {
        this.ref = ref;
    }

    @Override
    public void addErrorHandlers(RouteContext routeContext, OnExceptionDefinition exception) {
        ErrorHandlerBuilder handler = this.handlers.get(routeContext);
        if (handler != null) {
            handler.addErrorHandlers(routeContext, exception);
        }
        super.addErrorHandlers(routeContext, exception);
    }

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        ErrorHandlerBuilder handler = this.handlers.get(routeContext);
        if (handler == null) {
            handler = this.createErrorHandler(routeContext);
            this.handlers.put(routeContext, handler);
        }
        return handler.createErrorHandler(routeContext, processor);
    }

    @Override
    public boolean supportTransacted() {
        return this.supportTransacted;
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        ErrorHandlerBuilderRef answer = new ErrorHandlerBuilderRef(this.ref);
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(ErrorHandlerBuilderRef other) {
        super.cloneBuilder(other);
        other.supportTransacted = this.supportTransacted;
    }

    public static ErrorHandlerFactory lookupErrorHandlerBuilder(RouteContext routeContext, String ref) {
        ErrorHandlerFactory answer;
        if (!ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured(ref)) {
            answer = routeContext.getRoute().getErrorHandlerBuilder();
            if (answer == null && routeContext.getRoute().getErrorHandlerRef() != null) {
                answer = routeContext.lookup(routeContext.getRoute().getErrorHandlerRef(), ErrorHandlerBuilder.class);
            }
            if (answer == null) {
                answer = new DefaultErrorHandlerBuilder();
            }
            if (answer instanceof ErrorHandlerBuilderRef) {
                ErrorHandlerBuilderRef other = (ErrorHandlerBuilderRef)answer;
                String otherRef = other.getRef();
                if (!ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured(otherRef)) {
                    answer = ErrorHandlerBuilderRef.lookupErrorHandlerBuilder((ModelCamelContext)routeContext.getCamelContext());
                }
                if (answer == null) {
                    answer = new DefaultErrorHandlerBuilder();
                }
                ((ErrorHandlerBuilder)answer).setErrorHandlers(routeContext, other.getErrorHandlers(routeContext));
            }
        } else {
            answer = routeContext.mandatoryLookup(ref, ErrorHandlerBuilder.class);
        }
        return answer;
    }

    protected static ErrorHandlerFactory lookupErrorHandlerBuilder(ModelCamelContext camelContext) {
        ErrorHandlerBuilderRef other;
        String otherRef;
        ErrorHandlerFactory answer = camelContext.getErrorHandlerBuilder();
        if (answer instanceof ErrorHandlerBuilderRef && ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured(otherRef = (other = (ErrorHandlerBuilderRef)answer).getRef()) && (answer = (ErrorHandlerFactory)camelContext.getRegistry().lookup(otherRef, ErrorHandlerBuilder.class)) == null) {
            throw new IllegalArgumentException("ErrorHandlerBuilder with id " + otherRef + " not found in registry.");
        }
        return answer;
    }

    public static boolean isErrorHandlerBuilderConfigured(String ref) {
        return !DEFAULT_ERROR_HANDLER_BUILDER.equals(ref);
    }

    public String getRef() {
        return this.ref;
    }

    private ErrorHandlerBuilder createErrorHandler(RouteContext routeContext) {
        ErrorHandlerBuilder handler = (ErrorHandlerBuilder)ErrorHandlerBuilderRef.lookupErrorHandlerBuilder(routeContext, this.getRef());
        ObjectHelper.notNull(handler, "error handler '" + this.ref + "'");
        this.supportTransacted = handler.supportTransacted();
        List<OnExceptionDefinition> list = this.getErrorHandlers(routeContext);
        if (list != null) {
            for (OnExceptionDefinition exceptionType : list) {
                handler.addErrorHandlers(routeContext, exceptionType);
            }
        }
        return handler;
    }

    public String toString() {
        return "ErrorHandlerBuilderRef[" + this.ref + "]";
    }
}

