/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(TimerConsumer.class);
    private final TimerEndpoint endpoint;
    private volatile TimerTask task;

    public TimerConsumer(TimerEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        this.task = new TimerTask(){
            private final AtomicLong counter = new AtomicLong();

            @Override
            public void run() {
                if (!TimerConsumer.this.isTaskRunAllowed()) {
                    return;
                }
                try {
                    boolean fire;
                    long count = this.counter.incrementAndGet();
                    boolean bl = fire = TimerConsumer.this.endpoint.getRepeatCount() <= 0L || count <= TimerConsumer.this.endpoint.getRepeatCount();
                    if (fire) {
                        TimerConsumer.this.sendTimerExchange(count);
                    } else {
                        LOG.debug("Cancelling {} timer as repeat count limit reached after {} counts.", (Object)TimerConsumer.this.endpoint.getTimerName(), (Object)TimerConsumer.this.endpoint.getRepeatCount());
                        this.cancel();
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Error processing exchange. This exception will be ignored, to let the timer be able to trigger again.", e);
                }
            }
        };
        Timer timer = this.endpoint.getTimer();
        this.configureTask(this.task, timer);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
    }

    protected boolean isTaskRunAllowed() {
        return this.endpoint.getCamelContext().getStatus().isStarted() && this.isRunAllowed() && !this.isSuspended();
    }

    protected void configureTask(TimerTask task, Timer timer) {
        if (this.endpoint.isFixedRate()) {
            if (this.endpoint.getTime() != null) {
                timer.scheduleAtFixedRate(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.scheduleAtFixedRate(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
            }
        } else if (this.endpoint.getTime() != null) {
            if (this.endpoint.getPeriod() > 0L) {
                timer.schedule(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.schedule(task, this.endpoint.getTime());
            }
        } else if (this.endpoint.getPeriod() > 0L) {
            timer.schedule(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
        } else {
            timer.schedule(task, this.endpoint.getDelay());
        }
    }

    protected void sendTimerExchange(long counter) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.setProperty("CamelTimerCounter", counter);
        exchange.setProperty("CamelTimerName", this.endpoint.getTimerName());
        exchange.setProperty("CamelTimerTime", this.endpoint.getTime());
        exchange.setProperty("CamelTimerPeriod", this.endpoint.getPeriod());
        Date now = new Date();
        exchange.setProperty("CamelTimerFiredTime", now);
        exchange.getIn().setHeader("firedTime", now);
        LOG.trace("Timer {} is firing #{} count", (Object)this.endpoint.getTimerName(), (Object)counter);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
        }
    }
}

