/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.IsSingleton;
import org.apache.camel.PollingConsumer;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerCache
extends ServiceSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerCache.class);
    private final CamelContext camelContext;
    private final Map<String, PollingConsumer> consumers;
    private final Object source;

    public ConsumerCache(Object source, CamelContext camelContext) {
        this(source, camelContext, CamelContextHelper.getMaximumCachePoolSize(camelContext));
    }

    public ConsumerCache(Object source, CamelContext camelContext, int cacheSize) {
        this(source, camelContext, ConsumerCache.createLRUCache(cacheSize));
    }

    public ConsumerCache(Object source, CamelContext camelContext, Map<String, PollingConsumer> cache) {
        this.camelContext = camelContext;
        this.consumers = cache;
        this.source = source;
    }

    protected static LRUCache<String, PollingConsumer> createLRUCache(int cacheSize) {
        return new LRUCache<String, PollingConsumer>(cacheSize);
    }

    public synchronized PollingConsumer getConsumer(Endpoint endpoint) {
        String key = endpoint.getEndpointUri();
        PollingConsumer answer = this.consumers.get(key);
        if (answer == null) {
            try {
                answer = endpoint.createPollingConsumer();
                answer.start();
            }
            catch (Exception e) {
                throw new FailedToCreateConsumerException(endpoint, (Throwable)e);
            }
            boolean singleton = true;
            if (answer instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)answer)).isSingleton();
            }
            if (singleton) {
                LOG.debug("Adding to consumer cache with key: {} for consumer: {}", endpoint, (Object)answer);
                this.consumers.put(key, answer);
            } else {
                LOG.debug("Consumer for endpoint: {} is not singleton and thus not added to consumer cache", (Object)key);
            }
        }
        return answer;
    }

    public Exchange receive(Endpoint endpoint) {
        LOG.debug("<<<< {}", endpoint);
        PollingConsumer consumer = this.getConsumer(endpoint);
        return consumer.receive();
    }

    public Exchange receive(Endpoint endpoint, long timeout) {
        LOG.debug("<<<< {}", endpoint);
        PollingConsumer consumer = this.getConsumer(endpoint);
        return consumer.receive(timeout);
    }

    public Exchange receiveNoWait(Endpoint endpoint) {
        LOG.debug("<<<< {}", endpoint);
        PollingConsumer consumer = this.getConsumer(endpoint);
        return consumer.receiveNoWait();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public int size() {
        int size = this.consumers.size();
        LOG.trace("size = {}", size);
        return size;
    }

    public int getCapacity() {
        int capacity = -1;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            capacity = cache.getMaxCacheSize();
        }
        return capacity;
    }

    public long getHits() {
        long hits = -1L;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            hits = cache.getHits();
        }
        return hits;
    }

    public long getMisses() {
        long misses = -1L;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            misses = cache.getMisses();
        }
        return misses;
    }

    public long getEvicted() {
        long evicted = -1L;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            evicted = cache.getEvicted();
        }
        return evicted;
    }

    public void resetCacheStatistics() {
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            cache.resetStatistics();
        }
    }

    public synchronized void purge() {
        this.consumers.clear();
    }

    public String toString() {
        return "ConsumerCache for source: " + this.source + ", capacity: " + this.getCapacity();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.consumers.values());
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.consumers.values());
        this.consumers.clear();
    }
}

