/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.camel.Exchange;
import org.apache.camel.impl.MessageSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.MessageHelper;

public class DefaultMessage
extends MessageSupport {
    private boolean fault;
    private Map<String, Object> headers;
    private Map<String, DataHandler> attachments;

    public String toString() {
        return MessageHelper.extractBodyForLogging(this);
    }

    @Override
    public boolean isFault() {
        return this.fault;
    }

    @Override
    public void setFault(boolean fault) {
        this.fault = fault;
    }

    @Override
    public Object getHeader(String name) {
        if (this.hasHeaders()) {
            return this.getHeaders().get(name);
        }
        return null;
    }

    @Override
    public Object getHeader(String name, Object defaultValue) {
        Object answer = this.getHeaders().get(name);
        return answer != null ? answer : defaultValue;
    }

    @Override
    public <T> T getHeader(String name, Class<T> type) {
        Object value = this.getHeader(name);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    @Override
    public <T> T getHeader(String name, Object defaultValue, Class<T> type) {
        Object value = this.getHeader(name, defaultValue);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    @Override
    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        this.headers.put(name, value);
    }

    @Override
    public Object removeHeader(String name) {
        if (!this.hasHeaders()) {
            return null;
        }
        return this.headers.remove(name);
    }

    @Override
    public boolean removeHeaders(String pattern) {
        return this.removeHeaders(pattern, null);
    }

    @Override
    public boolean removeHeaders(String pattern, String ... excludePatterns) {
        if (!this.hasHeaders()) {
            return false;
        }
        boolean matches = false;
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            if (!EndpointHelper.matchPattern(key, pattern) || excludePatterns != null && DefaultMessage.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            this.headers.remove(entry.getKey());
        }
        return matches;
    }

    @Override
    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers instanceof CaseInsensitiveMap ? headers : new CaseInsensitiveMap((Map<? extends String, ?>)headers);
    }

    @Override
    public boolean hasHeaders() {
        if (!this.hasPopulatedHeaders()) {
            this.getHeaders();
        }
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public DefaultMessage newInstance() {
        return new DefaultMessage();
    }

    protected Map<String, Object> createHeaders() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        this.populateInitialHeaders(map);
        return map;
    }

    protected Map<String, DataHandler> createAttachments() {
        HashMap<String, DataHandler> map = new HashMap<String, DataHandler>();
        this.populateInitialAttachments(map);
        return map;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
    }

    protected void populateInitialAttachments(Map<String, DataHandler> map) {
    }

    protected Boolean isTransactedRedelivered() {
        return null;
    }

    @Override
    public void addAttachment(String id, DataHandler content) {
        if (this.attachments == null) {
            this.attachments = this.createAttachments();
        }
        this.attachments.put(id, content);
    }

    @Override
    public DataHandler getAttachment(String id) {
        return this.getAttachments().get(id);
    }

    @Override
    public Set<String> getAttachmentNames() {
        if (this.attachments == null) {
            this.attachments = this.createAttachments();
        }
        return this.attachments.keySet();
    }

    @Override
    public void removeAttachment(String id) {
        if (this.attachments != null && this.attachments.containsKey(id)) {
            this.attachments.remove(id);
        }
    }

    @Override
    public Map<String, DataHandler> getAttachments() {
        if (this.attachments == null) {
            this.attachments = this.createAttachments();
        }
        return this.attachments;
    }

    @Override
    public void setAttachments(Map<String, DataHandler> attachments) {
        this.attachments = attachments;
    }

    @Override
    public boolean hasAttachments() {
        return this.attachments != null && this.attachments.size() > 0;
    }

    protected boolean hasPopulatedHeaders() {
        return this.headers != null;
    }

    @Override
    public String createExchangeId() {
        return null;
    }

    private static boolean isExcludePatternMatch(String key, String ... excludePatterns) {
        for (String pattern : excludePatterns) {
            if (!EndpointHelper.matchPattern(key, pattern)) continue;
            return true;
        }
        return false;
    }
}

