/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.util.ServiceHelper;

public class ProcessorPollingConsumer
extends PollingConsumerSupport {
    private final Processor processor;

    public ProcessorPollingConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint);
        this.processor = processor;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    @Override
    public Exchange receive() {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(this + " is not started, but in state: " + this.getStatus().name());
        }
        Exchange exchange = this.getEndpoint().createExchange();
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Error while processing exchange", exchange, e);
        }
        return exchange;
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive();
    }

    @Override
    public Exchange receive(long timeout) {
        return this.receive();
    }
}

