/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedSendProcessorMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SendProcessor;

@ManagedResource(description="Managed SendProcessor")
public class ManagedSendProcessor
extends ManagedProcessor
implements ManagedSendProcessorMBean {
    private final SendProcessor processor;

    public ManagedSendProcessor(CamelContext context, SendProcessor processor, ProcessorDefinition<?> definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public SendProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public String getDestination() {
        return this.processor.getDestination().getEndpointUri();
    }

    @Override
    public void setDestination(String uri) {
        Endpoint endpoint = this.getContext().getEndpoint(uri);
        this.processor.setDestination(endpoint);
    }

    @Override
    public String getMessageExchangePattern() {
        if (this.processor.getPattern() != null) {
            return this.processor.getPattern().name();
        }
        return null;
    }
}

