/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatalFallbackErrorHandler
extends DelegateAsyncProcessor
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FatalFallbackErrorHandler.class);

    public FatalFallbackErrorHandler(Processor processor) {
        super(processor);
    }

    @Override
    protected boolean processNext(final Exchange exchange, final AsyncCallback callback) {
        boolean sync = super.processNext(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    Throwable previous = exchange.getProperty("CamelExceptionCaught", Throwable.class);
                    String msg = "Exception occurred while trying to handle previously thrown exception on exchangeId: " + exchange.getExchangeId() + " using: [" + FatalFallbackErrorHandler.this.processor + "].";
                    if (previous != null) {
                        msg = msg + " The previous and the new exception will be logged in the following.";
                        LOG.error(msg);
                        LOG.error("\\--> Previous exception on exchangeId: " + exchange.getExchangeId(), previous);
                        LOG.error("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                    } else {
                        LOG.error(msg);
                        LOG.error("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                    }
                    exchange.setProperty("CamelExceptionCaught", exchange.getException());
                    exchange.setProperty("CamelErrorHandlerHandled", false);
                }
                callback.done(doneSync);
            }
        });
        return sync;
    }

    @Override
    public String toString() {
        return "FatalFallbackErrorHandler[" + this.processor + "]";
    }
}

