/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.support.ServiceSupport;

public class MemoryAggregationRepository
extends ServiceSupport
implements AggregationRepository {
    private final Map<String, Exchange> cache = new ConcurrentHashMap<String, Exchange>();

    @Override
    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        return this.cache.put(key, exchange);
    }

    @Override
    public Exchange get(CamelContext camelContext, String key) {
        return this.cache.get(key);
    }

    @Override
    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        this.cache.remove(key);
    }

    @Override
    public void confirm(CamelContext camelContext, String exchangeId) {
    }

    @Override
    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        this.cache.clear();
    }
}

