/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.processor.validation.NoXmlBodyValidationException;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.apache.camel.processor.validation.ValidatorErrorHandler;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingProcessor.class);
    private XmlConverter converter = new XmlConverter();
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Schema schema;
    private Source schemaSource;
    private SchemaFactory schemaFactory;
    private URL schemaUrl;
    private File schemaFile;
    private ValidatorErrorHandler errorHandler = new DefaultValidationErrorHandler();
    private boolean useDom;
    private boolean useSharedSchema = true;
    private LSResourceResolver resourceResolver;
    private boolean failOnNullBody = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        InputStream is;
        block16: {
            Schema schema = this.isUseSharedSchema() ? this.getSchema() : this.createSchema();
            Validator validator = schema.newValidator();
            Source source = null;
            is = null;
            try {
                Result result = null;
                if (this.isInputStreamNeeded(exchange)) {
                    is = exchange.getIn().getBody(InputStream.class);
                    if (is != null) {
                        source = this.getSource(exchange, is);
                    }
                } else {
                    Object body = exchange.getIn().getBody();
                    if (body != null) {
                        source = this.getSource(exchange, body);
                    }
                }
                if (source == null && this.isFailOnNullBody()) {
                    throw new NoXmlBodyValidationException(exchange);
                }
                if (source instanceof DOMSource) {
                    result = new DOMResult();
                } else if (source instanceof StreamSource) {
                    result = new StreamResult(new StringWriter());
                } else if (source instanceof SAXSource) {
                    result = new SAXResult();
                } else if (source instanceof StAXSource) {
                    result = null;
                }
                if (source == null) break block16;
                ValidatorErrorHandler handler = (ValidatorErrorHandler)this.errorHandler.getClass().newInstance();
                validator.setErrorHandler(handler);
                try {
                    LOG.trace("Validating {}", source);
                    validator.validate(source, result);
                    handler.handleErrors(exchange, schema, result);
                }
                catch (SAXParseException e) {
                    throw new SchemaValidationException(exchange, schema, Collections.singletonList(e), Collections.<SAXParseException>emptyList(), Collections.<SAXParseException>emptyList());
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(is);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)is);
    }

    public void loadSchema() throws Exception {
        this.schema = this.createSchema();
    }

    public Schema getSchema() throws IOException, SAXException {
        if (this.schema == null) {
            this.schema = this.createSchema();
        }
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Source getSchemaSource() throws IOException {
        if (this.schemaSource == null) {
            this.schemaSource = this.createSchemaSource();
        }
        return this.schemaSource;
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaSource = schemaSource;
    }

    public URL getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(URL schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            this.schemaFactory = this.createSchemaFactory();
        }
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public ValidatorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ValidatorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Deprecated
    public boolean isUseDom() {
        return this.useDom;
    }

    @Deprecated
    public void setUseDom(boolean useDom) {
        this.useDom = useDom;
    }

    public boolean isUseSharedSchema() {
        return this.useSharedSchema;
    }

    public void setUseSharedSchema(boolean useSharedSchema) {
        this.useSharedSchema = useSharedSchema;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    protected SchemaFactory createSchemaFactory() {
        SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
        if (this.getResourceResolver() != null) {
            factory.setResourceResolver(this.getResourceResolver());
        }
        return factory;
    }

    protected Source createSchemaSource() throws IOException {
        throw new IllegalArgumentException("You must specify either a schema, schemaFile, schemaSource or schemaUrl property");
    }

    protected Schema createSchema() throws SAXException, IOException {
        SchemaFactory factory = this.getSchemaFactory();
        URL url = this.getSchemaUrl();
        if (url != null) {
            return factory.newSchema(url);
        }
        File file = this.getSchemaFile();
        if (file != null) {
            return factory.newSchema(file);
        }
        return factory.newSchema(this.getSchemaSource());
    }

    protected boolean isInputStreamNeeded(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body == null) {
            return false;
        }
        if (body instanceof InputStream) {
            return true;
        }
        if (body instanceof Source) {
            return false;
        }
        if (body instanceof String) {
            return false;
        }
        if (body instanceof byte[]) {
            return false;
        }
        if (body instanceof Node) {
            return false;
        }
        return exchange.getContext().getTypeConverterRegistry().lookup(Source.class, body.getClass()) == null;
    }

    protected Source getSource(Exchange exchange, Object body) {
        TypeConverter tc;
        if (this.isUseDom()) {
            return exchange.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange, body);
        }
        if (body instanceof Source) {
            return (Source)body;
        }
        Source source = null;
        if (body instanceof InputStream) {
            return new StreamSource((InputStream)body);
        }
        if (body != null && (tc = exchange.getContext().getTypeConverterRegistry().lookup(Source.class, body.getClass())) != null) {
            source = tc.convertTo(Source.class, exchange, body);
        }
        if (source == null) {
            source = exchange.getContext().getTypeConverter().tryConvertTo(SAXSource.class, exchange, body);
        }
        if (source == null) {
            source = exchange.getContext().getTypeConverter().tryConvertTo(StreamSource.class, exchange, body);
        }
        if (source == null) {
            source = exchange.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange, body);
        }
        if (source == null) {
            if (this.isFailOnNullBody()) {
                throw new ExpectedBodyTypeException(exchange, Source.class);
            }
            try {
                source = this.converter.toDOMSource(this.converter.createDocument());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeTransformException(e);
            }
        }
        return source;
    }
}

