/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.fusesource.fabric.stream.log.SnappyDecompressor;
import org.fusesource.fabric.stream.log.Support;

public class Consumer {
    String broker;
    String destination;
    String target;
    boolean uncompress = false;

    public static void main(String[] args) throws Exception {
        Consumer consumer = new Consumer();
        LinkedList<String> argl = new LinkedList<String>(Arrays.asList(args));
        while (!argl.isEmpty()) {
            try {
                String arg = argl.removeFirst();
                if ("--help".equals(arg)) {
                    Consumer.displayHelpAndExit(0);
                    continue;
                }
                if ("--broker".equals(arg)) {
                    consumer.broker = Consumer.shift(argl);
                    continue;
                }
                if ("--destination".equals(arg)) {
                    consumer.destination = Consumer.shift(argl);
                    continue;
                }
                if ("--target".equals(arg)) {
                    consumer.target = Consumer.shift(argl);
                    continue;
                }
                if ("--uncompress".equals(arg)) {
                    consumer.uncompress = Boolean.parseBoolean(Consumer.shift(argl));
                    continue;
                }
                System.err.println("Invalid usage: unknown option: " + arg);
                Consumer.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid usage: argument not a number");
                Consumer.displayHelpAndExit(1);
            }
        }
        if (consumer.broker == null) {
            System.err.println("Invalid usage: --broker option not specified.");
            Consumer.displayHelpAndExit(1);
        }
        if (consumer.destination == null) {
            System.err.println("Invalid usage: --destination option not specified.");
            Consumer.displayHelpAndExit(1);
        }
        consumer.execute();
        System.exit(0);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            System.err.println("Invalid usage: Missing argument");
            Consumer.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    private static void displayHelpAndExit(int exitCode) {
        Support.displayResourceFile("consumer-usage.txt");
        System.exit(exitCode);
    }

    private void execute() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.disableJMX();
        context.addComponent("activemq", ActiveMQComponent.activeMQComponent(this.broker));
        context.addRoutes(new RouteBuilder(){

            @Override
            public void configure() throws Exception {
                RouteDefinition route = this.from("activemq:" + Consumer.this.destination);
                if (Consumer.this.uncompress) {
                    route = (RouteDefinition)route.process(new SnappyDecompressor());
                }
                route.to(Consumer.this.target);
            }
        });
        context.start();
        Consumer consumer = this;
        synchronized (consumer) {
            while (true) {
                this.wait();
            }
        }
    }
}

