/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.activemq.util.IntrospectionSupport;
import org.fusesource.fabric.stream.log.HttpSimulator;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class HttpSimulatorFactory
implements ManagedServiceFactory {
    HashMap<String, HttpSimulator> simulators = new HashMap();

    public String getName() {
        return "Http Simulator Factory";
    }

    public synchronized void updated(String pid, Dictionary dictionary) throws ConfigurationException {
        try {
            this.deleted(pid);
            this.simulators.put(pid, this.createSimulator(HttpSimulatorFactory.toMap(dictionary)));
        }
        catch (Throwable e) {
            throw (ConfigurationException)new ConfigurationException(null, "Unable to parse configuration: " + e.getMessage()).initCause(e);
        }
    }

    public synchronized void deleted(String s) {
        HttpSimulator simulator = this.simulators.remove(s);
        if (simulator != null) {
            simulator.stop();
        }
    }

    public void destroy() {
        for (String key : new ArrayList<String>(this.simulators.keySet())) {
            this.deleted(key);
        }
    }

    private HttpSimulator createSimulator(HashMap<String, String> properties) {
        HttpSimulator simulator = new HttpSimulator();
        IntrospectionSupport.setProperties(simulator, properties);
        simulator.start();
        return simulator;
    }

    public static HashMap<String, String> toMap(Dictionary dictionary) {
        HashMap<String, String> rc = new HashMap<String, String>();
        Enumeration ek = dictionary.keys();
        while (ek.hasMoreElements()) {
            Object key = ek.nextElement();
            Object value = dictionary.get(key);
            if (key == null || value == null) continue;
            rc.put(key.toString(), value.toString());
        }
        return rc;
    }
}

