/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentScanAnnotationParser {
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private final BeanDefinitionRegistry registry;
    private final BeanNameGenerator beanNameGenerator;

    public ComponentScanAnnotationParser(ResourceLoader resourceLoader, Environment environment, BeanNameGenerator beanNameGenerator, BeanDefinitionRegistry registry) {
        this.resourceLoader = resourceLoader;
        this.environment = environment;
        this.beanNameGenerator = beanNameGenerator;
        this.registry = registry;
    }

    public Set<BeanDefinitionHolder> parse(AnnotationAttributes componentScan) {
        AnnotationAttributes filter;
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this.registry, componentScan.getBoolean("useDefaultFilters"));
        Assert.notNull(this.environment, "Environment must not be null");
        scanner.setEnvironment(this.environment);
        Assert.notNull(this.resourceLoader, "ResourceLoader must not be null");
        scanner.setResourceLoader(this.resourceLoader);
        Class generatorClass = componentScan.getClass("nameGenerator");
        boolean useInheritedGenerator = BeanNameGenerator.class.equals(generatorClass);
        scanner.setBeanNameGenerator(useInheritedGenerator ? this.beanNameGenerator : (BeanNameGenerator)BeanUtils.instantiateClass(generatorClass));
        ScopedProxyMode scopedProxyMode = (ScopedProxyMode)((Object)componentScan.getEnum("scopedProxy"));
        if (scopedProxyMode != ScopedProxyMode.DEFAULT) {
            scanner.setScopedProxyMode(scopedProxyMode);
        } else {
            Class resolverClass = componentScan.getClass("scopeResolver");
            scanner.setScopeMetadataResolver((ScopeMetadataResolver)BeanUtils.instantiateClass(resolverClass));
        }
        scanner.setResourcePattern(componentScan.getString("resourcePattern"));
        AnnotationAttributes[] annotationAttributesArray = componentScan.getAnnotationArray("includeFilters");
        int n = annotationAttributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            filter = annotationAttributesArray[n2];
            for (TypeFilter typeFilter : this.typeFiltersFor(filter)) {
                scanner.addIncludeFilter(typeFilter);
            }
            ++n2;
        }
        annotationAttributesArray = componentScan.getAnnotationArray("excludeFilters");
        n = annotationAttributesArray.length;
        n2 = 0;
        while (n2 < n) {
            filter = annotationAttributesArray[n2];
            for (TypeFilter typeFilter : this.typeFiltersFor(filter)) {
                scanner.addExcludeFilter(typeFilter);
            }
            ++n2;
        }
        ArrayList<String> basePackages = new ArrayList<String>();
        Object[] objectArray = componentScan.getStringArray("value");
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            String pkg = objectArray[n];
            if (StringUtils.hasText(pkg)) {
                basePackages.add(pkg);
            }
            ++n;
        }
        objectArray = componentScan.getStringArray("basePackages");
        n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            String pkg = objectArray[n];
            if (StringUtils.hasText(pkg)) {
                basePackages.add(pkg);
            }
            ++n;
        }
        objectArray = componentScan.getClassArray("basePackageClasses");
        n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object clazz = objectArray[n];
            basePackages.add(ClassUtils.getPackageName(clazz));
            ++n;
        }
        if (basePackages.isEmpty()) {
            throw new IllegalStateException("At least one base package must be specified");
        }
        return scanner.doScan(basePackages.toArray(new String[0]));
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)((Object)filterAttributes.getEnum("type"));
        Class<?>[] classArray = filterAttributes.getClassArray("value");
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> filterClass = classArray[n2];
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, filterClass, "An error occured when processing a @ComponentScan ANNOTATION type filter: ");
                    Class<?> annoClass = filterClass;
                    typeFilters.add(new AnnotationTypeFilter(annoClass));
                    break;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add(new AssignableTypeFilter(filterClass));
                    break;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, filterClass, "An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add(BeanUtils.instantiateClass(filterClass, TypeFilter.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown filter type " + (Object)((Object)filterType));
                }
            }
            ++n2;
        }
        return typeFilters;
    }
}

