/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Namespace;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.TextUtils;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLUtils;
import de.pdark.decentxml.XMLWriter;
import java.io.IOException;

public class Attribute
extends BasicNode {
    private Namespace namespace;
    private String preSpace = " ";
    private String name;
    private String equalsSpace = "=";
    private String rawValue;
    private String value;
    private char quoteChar;

    public Attribute(Token token) {
        super(token);
        char c;
        int pos;
        String s = token.getText();
        int N = s.length();
        int start = pos = 0;
        while (Character.isWhitespace(s.charAt(pos)) && pos < N) {
            ++pos;
        }
        if (pos != start) {
            this.preSpace = s.substring(start, pos);
        }
        start = pos;
        while (pos < N && !Character.isWhitespace(c = s.charAt(pos)) && c != '=') {
            ++pos;
        }
        this.name = s.substring(start, pos);
        start = pos;
        while (pos < N && (Character.isWhitespace(c = s.charAt(pos)) || c == '=')) {
            ++pos;
        }
        this.equalsSpace = s.substring(start, pos);
        this.quoteChar = s.charAt(pos);
        this.rawValue = s.substring(pos + 1, N - 1);
        this.value = XMLUtils.unescapeXMLAttributeValue(this.rawValue);
        this.setNamespace(null);
    }

    public Attribute(String name, String value) {
        this(name, value, null, '\u0000');
    }

    public Attribute(String name, String value, Namespace namespace) {
        this(name, value, namespace, '\u0000');
    }

    public Attribute(String name, String value, char quoteChar) {
        this(name, value, null, quoteChar);
    }

    public Attribute(String name, String value, Namespace namespace, char quoteChar) {
        super(XMLTokenizer.Type.ATTRIBUTE, null);
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("name is blank");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.name = name;
        this.value = value;
        this.setNamespace(namespace);
        this.quoteChar = Attribute.checkQuoteChar(value, quoteChar);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = value;
        this.rawValue = null;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
    }

    public int getQuoteChar() {
        return this.quoteChar;
    }

    public Attribute setQuoteChar(char quoteChar) {
        this.quoteChar = Attribute.checkQuoteChar(this.getValue(), quoteChar);
        return this;
    }

    public String getPreSpace() {
        return this.preSpace;
    }

    public Attribute setPreSpace(String preSpace) {
        if (preSpace == null) {
            preSpace = " ";
        } else if (preSpace.trim().length() != 0) {
            throw new IllegalArgumentException("Space prefix must not contain anything besides whitespace: " + TextUtils.escapeJavaString(preSpace));
        }
        this.preSpace = preSpace;
        return this;
    }

    public String getEqualsSpace() {
        return this.equalsSpace;
    }

    public Attribute setEqualsSpace(String equalsSpace) {
        if (equalsSpace == null) {
            equalsSpace = "=";
        } else if (!"=".equals(equalsSpace.trim())) {
            throw new IllegalArgumentException("Space around equals sign must not contain anything besides whitespace: " + TextUtils.escapeJavaString(equalsSpace));
        }
        this.equalsSpace = equalsSpace;
        return this;
    }

    public static char checkQuoteChar(String value, char quoteChar) {
        if (quoteChar == '\u0000') {
            quoteChar = !value.contains("\"") ? (char)34 : (!value.contains("'") ? (char)39 : (char)34);
        } else if (quoteChar != '\"' && quoteChar != '\'') {
            char[] buffer = new char[]{quoteChar};
            String s = new String(buffer);
            throw new XMLParseException("Illegal quote charater: " + TextUtils.escapeJavaString(s) + " (" + quoteChar + ")");
        }
        return quoteChar;
    }

    public BasicNode toXML(XMLWriter writer) throws IOException {
        writer.write(this, this.getPreSpace());
        String prefix = this.getNamespace().getPrefix();
        if (prefix.length() != 0) {
            writer.write(this, prefix);
            writer.write(this, ":");
        }
        writer.write(this, this.getName());
        writer.write(this, this.getEqualsSpace());
        char[] buffer = new char[]{this.quoteChar};
        String s = new String(buffer);
        writer.write(this, s);
        if (this.rawValue != null) {
            writer.write(this, this.rawValue);
        } else {
            writer.writeAttributeValue(this, this.getValue(), this.quoteChar);
        }
        writer.write(this, s);
        return this;
    }

    public Attribute createClone() {
        return new Attribute(this.name, this.value);
    }

    public Attribute copy(Node orig) {
        super.copy(orig);
        Attribute other = (Attribute)orig;
        this.equalsSpace = other.equalsSpace;
        this.name = other.name;
        this.preSpace = other.preSpace;
        this.quoteChar = other.quoteChar;
        this.value = other.value;
        this.rawValue = other.rawValue;
        return this;
    }

    public Attribute copy() {
        return (Attribute)super.copy();
    }
}

