/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.TextUtils;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLTokenizer;

public class Token {
    private XMLSource source;
    private XMLTokenizer.Type type;
    private int startOffset;
    private int endOffset;

    public void setSource(XMLSource source) {
        this.source = source;
    }

    public XMLSource getSource() {
        return this.source;
    }

    public String getText() {
        return this.getSource() == null ? null : this.getSource().substring(this.getStartOffset(), this.getEndOffset());
    }

    public String getEscapedText() {
        return TextUtils.escapeJavaString(this.getText());
    }

    public String toString() {
        return "Token (" + (Object)((Object)this.getType()) + ", " + this.getStartOffset() + ":" + this.getEndOffset() + ", " + this.getEscapedText() + ")";
    }

    public void setType(XMLTokenizer.Type type) {
        this.type = type;
    }

    public XMLTokenizer.Type getType() {
        return this.type;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public int getEndOffset() {
        return this.endOffset < this.startOffset ? this.startOffset : this.endOffset;
    }

    public String getPrefixWhiteSpace() {
        char c;
        int pos;
        int N = this.getEndOffset();
        for (pos = this.getStartOffset(); pos < N && Character.isWhitespace(c = this.source.charAt(pos)); ++pos) {
        }
        return pos == 0 ? "" : this.source.substring(this.getStartOffset(), pos);
    }
}

