/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.boot.commands.support.EnsembleCommandSupport;

@Command(name="create", scope="fabric", description="Creates a new fabric ensemble (ZooKeeper ensemble) and imports fabric profiles", detailedDescription="classpath:create.txt")
public class Create
extends EnsembleCommandSupport
implements org.fusesource.fabric.boot.commands.service.Create {
    @Option(name="--clean", description="Clean local zookeeper cluster and configurations")
    private boolean clean;
    @Option(name="--no-import", description="Disable the import of the sample registry data")
    private boolean noImport;
    @Option(name="--import-dir", description="Directory of files to import into the newly created ensemble")
    private String importDir = Create.getDefaultImportDir();
    @Option(name="-v", aliases={"--verbose"}, description="Flag to enable verbose output of files being imported")
    boolean verbose = false;
    @Option(name="-r", aliases={"--resolver"}, description="The global resolver policy, which becomes the default resolver policy applied to all new containers created in this fabric. Possible values are: localip, localhostname, publicip, publichostname, manualip. Default is localhostname.")
    String resolver;
    @Option(name="-t", aliases={"--time"}, description="How long to wait (milliseconds) for the ensemble to start up before trying to import the default data")
    long ensembleStartupTime = 2000L;
    @Argument(required=false, multiValued=true, description="List of containers. Empty list assumes current container only.")
    private List<String> containers;

    protected Object doExecute() throws Exception {
        if (this.containers == null || this.containers.isEmpty()) {
            this.containers = Arrays.asList(System.getProperty("karaf.name"));
        }
        if (this.clean) {
            this.service.clean();
        }
        if (!this.noImport && this.importDir != null) {
            System.setProperty("profiles.auto.import.path", this.importDir);
        }
        if (this.resolver != null) {
            System.setProperty("global.resolver", this.resolver);
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            this.service.createCluster(this.containers);
        }
        return null;
    }

    private static String getDefaultImportDir() {
        return System.getProperty("karaf.home", ".") + File.separatorChar + "fabric" + File.separatorChar + "import";
    }

    @Override
    public Object run() throws Exception {
        return this.doExecute();
    }

    @Override
    public boolean isClean() {
        return this.clean;
    }

    @Override
    public void setClean(boolean clean) {
        this.clean = clean;
    }

    @Override
    public boolean isNoImport() {
        return this.noImport;
    }

    @Override
    public void setNoImport(boolean noImport) {
        this.noImport = noImport;
    }

    @Override
    public String getImportDir() {
        return this.importDir;
    }

    @Override
    public void setImportDir(String importDir) {
        this.importDir = importDir;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public long getEnsembleStartupTime() {
        return this.ensembleStartupTime;
    }

    @Override
    public void setEnsembleStartupTime(long ensembleStartupTime) {
        this.ensembleStartupTime = ensembleStartupTime;
    }

    @Override
    public List<String> getContainers() {
        return this.containers;
    }

    @Override
    public void setContainers(List<String> containers) {
        this.containers = containers;
    }
}

