/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel.c24io;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.Element;
import java.lang.reflect.InvocationTargetException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.ObjectHelper;
import org.fusesource.fabric.camel.c24io.TypeNotElementRuntimeException;

public final class C24IOHelper {
    private C24IOHelper() {
    }

    public static Element getElement(String modelClassName) {
        try {
            Class<?> elementType = Class.forName(modelClassName);
            return C24IOHelper.getElement(elementType);
        }
        catch (RuntimeCamelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public static Element getMandatoryElement(Class<?> type) {
        Element element = C24IOHelper.getElement(type);
        if (element == null) {
            throw new TypeNotElementRuntimeException(type);
        }
        return element;
    }

    public static Element getElement(Class<?> elementType) {
        Object object;
        if (Element.class.isAssignableFrom(elementType)) {
            try {
                Object value = elementType.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                if (value instanceof Element) {
                    return (Element)value;
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeCamelException(e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        if ((object = ObjectHelper.newInstance(elementType, Object.class)) instanceof Element) {
            return (Element)object;
        }
        if (object instanceof ComplexDataObject) {
            ComplexDataObject dataObject = (ComplexDataObject)object;
            return dataObject.getDefiningElementDecl();
        }
        return null;
    }
}

