/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel.c24io;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.DataModel;
import biz.c24.io.api.data.Element;
import biz.c24.io.api.presentation.Sink;
import biz.c24.io.api.presentation.Source;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.util.ObjectHelper;
import org.fusesource.fabric.camel.c24io.C24IOHelper;

public class FallbackTypeConverter
implements TypeConverter,
TypeConverterAware {
    private TypeConverter parentTypeConverter;
    private boolean prettyPrint = true;
    private Sink sink;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setTypeConverter(TypeConverter parentTypeConverter) {
        this.parentTypeConverter = parentTypeConverter;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            if (this.isComplexDataObject(type)) {
                return this.unmarshall(type, value, exchange);
            }
            if (value instanceof ComplexDataObject) {
                this.marshall(type, (ComplexDataObject)value, exchange);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected <T> boolean isComplexDataObject(Class<T> type) {
        return ComplexDataObject.class.isAssignableFrom(type);
    }

    protected <T> T unmarshall(Class<T> type, Object value, Exchange exchange) throws IOException {
        Element element = this.getElementForType(type, exchange);
        if (element == null) {
            return null;
        }
        Source source = this.getSource(type, element, exchange);
        boolean configured = false;
        if (this.parentTypeConverter != null) {
            try {
                InputStream inputStream = (InputStream)this.parentTypeConverter.mandatoryConvertTo(InputStream.class, value);
                source.setInputStream(inputStream);
                configured = true;
            }
            catch (NoTypeConversionAvailableException ex1) {
                try {
                    Reader reader = (Reader)this.parentTypeConverter.mandatoryConvertTo(Reader.class, value);
                    source.setReader(reader);
                    configured = true;
                }
                catch (NoTypeConversionAvailableException ex2) {
                    // empty catch block
                }
            }
            if (!configured) {
                if (value instanceof String) {
                    value = new StringReader((String)value);
                }
                if (value instanceof InputStream) {
                    source.setInputStream((InputStream)value);
                    configured = true;
                }
                if (value instanceof Reader) {
                    source.setReader((Reader)value);
                    configured = true;
                }
            }
        }
        if (configured) {
            ComplexDataObject object = source.readObject(element);
            return (T)ObjectHelper.cast(type, (Object)object);
        }
        return null;
    }

    protected Element getElementForType(Class<?> type, Exchange exchange) {
        return C24IOHelper.getElement(type);
    }

    protected <T> T marshall(Class<T> type, ComplexDataObject dataObject, Exchange exchange) throws IOException {
        if (this.parentTypeConverter != null) {
            Sink sink = this.getSink(dataObject, exchange);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            sink.setOutputStream((OutputStream)buffer);
            sink.writeObject(dataObject);
            byte[] data = buffer.toByteArray();
            try {
                return (T)this.parentTypeConverter.mandatoryConvertTo(type, (Object)data);
            }
            catch (NoTypeConversionAvailableException e) {
                return null;
            }
        }
        return null;
    }

    protected Source getSource(Class<?> type, Element element, Exchange exchange) {
        Source answer = null;
        if (exchange != null) {
            answer = (Source)exchange.getProperty("c24io.source", Source.class);
        }
        if (answer == null) {
            DataModel model = element.getModel();
            answer = model.source();
        }
        return answer;
    }

    protected Sink getSink(ComplexDataObject dataObject, Exchange exchange) {
        Sink answer = null;
        if (exchange != null) {
            answer = (Sink)exchange.getProperty("c24io.sink", Sink.class);
        }
        if (answer == null) {
            answer = dataObject.getModel().sink();
        }
        return answer;
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        T answer = this.convertTo(type, exchange, value);
        if (answer == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return answer;
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        T answer = this.convertTo(type, value);
        if (answer == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return answer;
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return this.convertTo(type, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        try {
            return this.convertTo(type, value);
        }
        catch (Exception e) {
            return null;
        }
    }
}

