/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="patch-apply-upgrades", scope="fabric", description="Apply the given upgrades")
public class PatchApplyUpgrades
extends FabricCommand {
    @Option(name="--version", description="Only apply upgrades for the given version")
    private String version;
    @Option(name="--profile", description="Only apply upgrades for the given profile (if no version is specified, the default one is used")
    private String profile;
    @Argument
    private Map<String, String> upgrades;

    protected Object doExecute() throws Exception {
        Version v = null;
        if (this.version != null && !this.version.isEmpty()) {
            v = this.fabricService.getVersion(this.version);
        }
        Profile p = null;
        if (this.profile != null && !this.profile.isEmpty()) {
            if (v == null) {
                v = this.fabricService.getDefaultVersion();
            }
            p = v.getProfile(this.profile);
        }
        if (p != null) {
            this.fabricService.getPatchService().applyUpgrades(p, this.upgrades);
        } else if (v != null) {
            this.fabricService.getPatchService().applyUpgrades(v, this.upgrades);
        } else {
            this.fabricService.getPatchService().applyUpgrades(this.upgrades);
        }
        return null;
    }
}

