/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="profile-delete", scope="fabric", description="Delete the specified version of the specified profile (where the version defaults to the current default version)")
public class ProfileDelete
extends FabricCommand {
    @Option(name="--version", description="The profile version to delete. Defaults to the current default version.")
    private String version;
    @Argument(index=0, required=true, name="profile", description="Name of the profile to delete.")
    @CompleterValues(index=0)
    private String name;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        for (Profile profile : ver.getProfiles()) {
            if (!this.name.equals(profile.getId())) continue;
            profile.delete();
        }
        return null;
    }
}

