/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="version-set-default", scope="fabric", description="Set the new default version (must be one of the existing versions)", detailedDescription="classpath:versionSetDefault.txt")
public class VersionSetDefault
extends FabricCommand {
    @Argument(index=0, description="Version number to use as new default version.", required=true)
    private String versionName;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Version version = this.fabricService.getVersion(this.versionName);
        if (version == null) {
            throw new IllegalArgumentException("Cannot find version: " + this.versionName);
        }
        Version currentDefault = this.fabricService.getDefaultVersion();
        if (version.compareTo((Object)currentDefault) == 0) {
            System.out.println("Version " + version + " is already default version.");
        } else {
            this.fabricService.setDefaultVersion(version);
            System.out.println("Changed default version to " + version);
        }
        return null;
    }
}

