/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.fusesource.fabric.groups.Group;

public class FabricServerListener
implements ServerLifeCycleListener {
    private static final transient Log LOG = LogFactory.getLog(FabricServerListener.class);
    private final Group group;

    FabricServerListener(Group group) {
        this.group = group;
    }

    public void startServer(Server server) {
        String address = server.getEndpoint().getEndpointInfo().getAddress();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is start with address " + address));
        }
        try {
            this.group.join(address, address.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            LOG.warn((Object)("Cannot bind the address " + address + " to the group, due to "), (Throwable)ex);
        }
    }

    public void stopServer(Server server) {
        String address = server.getEndpoint().getEndpointInfo().getAddress();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is stopped with address " + address));
        }
        this.group.leave(address);
    }
}

