/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.fusesource.fabric.cxf.FabricLoadBalancerFeature;
import org.fusesource.fabric.cxf.FailOverTargetSelector;
import org.fusesource.fabric.cxf.FirstOneLoadBalanceStrategy;
import org.fusesource.fabric.cxf.LoadBalanceStrategy;
import org.fusesource.fabric.cxf.LoadBalanceTargetSelector;

public class FabricFailOverFeature
extends FabricLoadBalancerFeature {
    private static final transient Log LOG = LogFactory.getLog(FabricFailOverFeature.class);
    protected String exceptions;
    protected List<Class> exceptionList = new ArrayList<Class>();

    @Override
    protected LoadBalanceStrategy getDefaultLoadBalanceStrategy() {
        return new FirstOneLoadBalanceStrategy();
    }

    @Override
    protected LoadBalanceTargetSelector getDefaultLoadBalanceTargetSelector() {
        return new FailOverTargetSelector(this.exceptionList);
    }

    public void setExceptions(String exceptions) {
        this.exceptions = exceptions;
        if (exceptions != null) {
            String[] exceptionArray;
            for (String exception : exceptionArray = exceptions.split(";")) {
                try {
                    Class clazz = ClassLoaderUtils.loadClass((String)exception, ((Object)((Object)this)).getClass());
                    this.exceptionList.clear();
                    this.exceptionList.add(clazz);
                }
                catch (ClassNotFoundException ex) {
                    LOG.warn((Object)("Can't load the exception " + exception + " for the FabricFailOverFeature."));
                }
            }
        }
    }
}

