/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.cxf.LoadBalanceStrategy;
import org.fusesource.fabric.groups.ChangeListener;
import org.fusesource.fabric.groups.Group;

public abstract class FabricLoadBalanceStrategySupport
implements LoadBalanceStrategy {
    private static final transient Log LOG = LogFactory.getLog(FabricLoadBalanceStrategySupport.class);
    protected Group group;
    protected List<String> alternateAddressList = new CopyOnWriteArrayList<String>();

    @Override
    public void setGroup(final Group group) {
        this.group = group;
        group.add(new ChangeListener(){

            public void changed() {
                FabricLoadBalanceStrategySupport.this.alternateAddressList.clear();
                for (byte[] uri : group.members().values()) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Added the CXF endpoint address " + new String(uri, "UTF-8")));
                        }
                        FabricLoadBalanceStrategySupport.this.alternateAddressList.add(new String(uri, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }

            public void connected() {
                this.changed();
            }

            public void disconnected() {
                this.changed();
            }
        });
    }

    @Override
    public Group getGroup() {
        return this.group;
    }

    @Override
    public List<String> getAlternateAddressList() {
        return new ArrayList<String>(this.alternateAddressList);
    }
}

