/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.fusesource.fabric.cxf.FabricServerListener;
import org.fusesource.fabric.cxf.LoadBalanceStrategy;
import org.fusesource.fabric.cxf.LoadBalanceTargetSelector;
import org.fusesource.fabric.cxf.RandomLoadBalanceStrategy;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKClient;

public class FabricLoadBalancerFeature
extends AbstractFeature
implements BusLifeCycleListener {
    private static final transient Log LOG = LogFactory.getLog(FabricLoadBalancerFeature.class);
    private volatile IZKClient zkClient;
    private String zkRoot = "/fabric/cxf/endpoints/";
    private String fabricPath;
    private boolean shouldCloseZkClient = false;
    private long maximumConnectionTimeout = 10000L;
    private long connectionRetryTime = 100L;
    private volatile Group group;
    private LoadBalanceStrategy loadBalanceStrategy;
    private List<ACL> accessControlList = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    public void initialize(Client client, Bus bus) {
        LoadBalanceTargetSelector selector = this.getDefaultLoadBalanceTargetSelector();
        selector.setEndpoint(client.getEndpoint());
        try {
            selector.setLoadBalanceStrategy(this.getLoadBalanceStrategy());
            client.setConduitSelector((ConduitSelector)selector);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot setup the LoadBalanceStrategy due to " + e));
        }
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener((BusLifeCycleListener)this);
    }

    public void initialize(Bus bus) {
        try {
            FabricServerListener lister = new FabricServerListener(this.getGroup());
            ServerLifeCycleManager mgr = (ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class);
            if (mgr != null) {
                mgr.registerListener((ServerLifeCycleListener)lister);
            } else {
                LOG.error((Object)"Cannot find the ServerLifeCycleManager, we cannot publish the service through fabric.");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot initialize the bus with FabricLoadBalancerFeature due to " + ex));
        }
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener((BusLifeCycleListener)this);
    }

    protected LoadBalanceStrategy getDefaultLoadBalanceStrategy() {
        return new RandomLoadBalanceStrategy();
    }

    protected LoadBalanceTargetSelector getDefaultLoadBalanceTargetSelector() {
        return new LoadBalanceTargetSelector();
    }

    public synchronized Group getGroup() throws Exception {
        if (this.group == null) {
            this.group = ZooKeeperGroupFactory.create((IZKClient)this.getZkClient(), (String)(this.zkRoot + this.fabricPath), this.accessControlList);
        }
        return this.group;
    }

    public void destroy() throws Exception {
        if (this.zkClient != null && this.isShouldCloseZkClient()) {
            this.zkClient.close();
        }
    }

    public String getFabricPath() {
        return this.fabricPath;
    }

    public void setFabricPath(String fabricPath) {
        this.fabricPath = fabricPath;
    }

    public List<ACL> getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(List<ACL> accessControlList) {
        this.accessControlList = accessControlList;
    }

    public synchronized IZKClient getZkClient() throws Exception {
        if (this.zkClient == null) {
            String connectString = System.getProperty("zookeeper.url", "localhost:2181");
            ZKClient client = new ZKClient(connectString, Timespan.parse((String)"10s"), null);
            LOG.debug((Object)("IZKClient not be found in registry, creating new with connection " + connectString));
            this.zkClient = client;
            this.setShouldCloseZkClient(true);
        }
        if (this.zkClient instanceof ZKClient && !this.zkClient.isConnected()) {
            LOG.debug((Object)("Staring IZKClient " + this.zkClient));
            ((ZKClient)this.zkClient).start();
        }
        this.checkZkConnected();
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() throws Exception {
        if (this.loadBalanceStrategy == null) {
            this.loadBalanceStrategy = this.getDefaultLoadBalanceStrategy();
        }
        if (this.loadBalanceStrategy.getGroup() == null) {
            this.loadBalanceStrategy.setGroup(this.getGroup());
        }
        return this.loadBalanceStrategy;
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy strategy) {
        this.loadBalanceStrategy = strategy;
    }

    public void setShouldCloseZkClient(boolean closeZkClient) {
        this.shouldCloseZkClient = closeZkClient;
    }

    public boolean isShouldCloseZkClient() {
        return this.shouldCloseZkClient;
    }

    public long getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(long maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    public long getConnectionRetryTime() {
        return this.connectionRetryTime;
    }

    public void setConnectionRetryTime(long connectionRetryTime) {
        this.connectionRetryTime = connectionRetryTime;
    }

    protected void checkZkConnected() throws Exception {
        long start = System.currentTimeMillis();
        do {
            if (this.zkClient.isConnected()) {
                return;
            }
            try {
                Thread.sleep(this.getConnectionRetryTime());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < start + this.getMaximumConnectionTimeout());
        if (!this.zkClient.isConnected()) {
            throw new Exception("Could not connect to ZooKeeper " + this.zkClient + " at " + this.zkClient.getConnectString());
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
    }

    public void postShutdown() {
        try {
            this.destroy();
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot shut down the zkClient due to " + e));
        }
    }
}

