/**
 * Copyright (C) FuseSource, Inc.
 * http://fusesource.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fusesource.fabric.cxf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticAddressResolver implements ServerAddressResolver {
    private static final transient Log LOG = LogFactory.getLog(StaticAddressResolver.class);
    private String prefixAddress;

    public void setPrefixAddress(String prefixAddress) {
        this.prefixAddress = prefixAddress;
    }

    public String getPrefixAddress() {
        return prefixAddress;
    }
    @Override
    public String getFullAddress(String address) {
        // Current CXF only supports these two schema address type
        if (!(address.startsWith("http") || address.startsWith("jms"))) {
            // we need to update the address with the prefixAddress as the Service is published from Servlet
            if (prefixAddress == null || prefixAddress.trim().length() == 0) {
                LOG.warn("Cannot find a full address for the CXF service of " + address + " , due to the configuration of prefixAddress");
                return address;
            }
            return prefixAddress + address;
        } else {
            return address;
        }
    }
}
