/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.cxf.ServerAddressResolver;

public class StaticAddressResolver
implements ServerAddressResolver {
    private static final transient Log LOG = LogFactory.getLog(StaticAddressResolver.class);
    private String prefixAddress;

    public void setPrefixAddress(String prefixAddress) {
        this.prefixAddress = prefixAddress;
    }

    public String getPrefixAddress() {
        return this.prefixAddress;
    }

    @Override
    public String getFullAddress(String address) {
        if (!address.startsWith("http") && !address.startsWith("jms")) {
            if (this.prefixAddress == null || this.prefixAddress.trim().length() == 0) {
                LOG.warn((Object)("Cannot find a full address for the CXF service of " + address + " , due to the configuration of prefixAddress"));
                return address;
            }
            return this.prefixAddress + address;
        }
        return address;
    }
}

