/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.fusesource.fabric.cxf.FabricServerListener;
import org.fusesource.fabric.cxf.LoadBalanceStrategy;
import org.fusesource.fabric.cxf.LoadBalanceTargetSelector;
import org.fusesource.fabric.cxf.RandomLoadBalanceStrategy;
import org.fusesource.fabric.cxf.ServerAddressResolver;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.internal.ZKClient;
import org.linkedin.util.clock.Timespan;

public class FabricLoadBalancerFeature
extends AbstractFeature
implements BusLifeCycleListener {
    private static final transient Log LOG = LogFactory.getLog(FabricLoadBalancerFeature.class);
    private static final String ZOOKEEPER_URL = "zookeeper.url";
    private static final String ZOOKEEPER_PASSWORD = "zookeeper.password";
    private volatile IZKClient zkClient;
    private String zooKeeperUrl;
    private String zooKeeperPassword;
    private String zkRoot = "/fabric/cxf/endpoints/";
    private String fabricPath;
    private boolean shouldCloseZkClient = false;
    private long maximumConnectionTimeout = 10000L;
    private volatile Group group;
    private LoadBalanceStrategy loadBalanceStrategy;
    private ServerAddressResolver addressResolver;

    public void initialize(Client client, Bus bus) {
        LoadBalanceTargetSelector selector = this.getDefaultLoadBalanceTargetSelector();
        selector.setEndpoint(client.getEndpoint());
        try {
            selector.setLoadBalanceStrategy(this.getLoadBalanceStrategy());
            client.setConduitSelector((ConduitSelector)selector);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot setup the LoadBalanceStrategy due to " + e));
        }
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener((BusLifeCycleListener)this);
    }

    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        if (interceptorProvider instanceof ConduitSelectorHolder) {
            ConduitSelectorHolder holder = (ConduitSelectorHolder)interceptorProvider;
            ConduitSelector oldSelector = holder.getConduitSelector();
            LoadBalanceTargetSelector selector = this.getDefaultLoadBalanceTargetSelector();
            selector.setEndpoint(oldSelector.getEndpoint());
            try {
                selector.setLoadBalanceStrategy(this.getLoadBalanceStrategy());
                holder.setConduitSelector((ConduitSelector)selector);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot setup the LoadBalanceStrategy due to " + e));
            }
            BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
            manager.registerLifeCycleListener((BusLifeCycleListener)this);
        }
    }

    public void initialize(Bus bus) {
        try {
            FabricServerListener lister = new FabricServerListener(this.getGroup(), this.addressResolver);
            ServerLifeCycleManager mgr = (ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class);
            if (mgr != null) {
                mgr.registerListener((ServerLifeCycleListener)lister);
            } else {
                LOG.error((Object)"Cannot find the ServerLifeCycleManager, we cannot publish the service through fabric.");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot initialize the bus with FabricLoadBalancerFeature due to " + ex));
        }
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener((BusLifeCycleListener)this);
    }

    protected LoadBalanceStrategy getDefaultLoadBalanceStrategy() {
        return new RandomLoadBalanceStrategy();
    }

    protected LoadBalanceTargetSelector getDefaultLoadBalanceTargetSelector() {
        return new LoadBalanceTargetSelector();
    }

    public synchronized Group getGroup() throws Exception {
        if (this.group == null) {
            this.group = ZooKeeperGroupFactory.create((IZKClient)this.getZkClient(), (String)(this.zkRoot + this.fabricPath));
        }
        return this.group;
    }

    public void destroy() throws Exception {
        if (this.zkClient != null && this.isShouldCloseZkClient()) {
            this.zkClient.close();
        }
    }

    public String getFabricPath() {
        return this.fabricPath;
    }

    public void setFabricPath(String fabricPath) {
        this.fabricPath = fabricPath;
    }

    public synchronized IZKClient getZkClient() throws Exception {
        if (this.zkClient == null) {
            String password;
            String connectString = this.getZooKeeperUrl();
            if (connectString == null) {
                connectString = System.getProperty(ZOOKEEPER_URL, "localhost:2181");
            }
            if ((password = this.getZooKeeperPassword()) == null) {
                System.getProperty(ZOOKEEPER_PASSWORD);
            }
            LOG.debug((Object)("IZKClient not find in camel registry, creating new with connection " + connectString));
            ZKClient client = new ZKClient(connectString, Timespan.milliseconds((long)this.getMaximumConnectionTimeout()), null);
            if (password != null && !password.isEmpty()) {
                client.setPassword(password);
            }
            this.zkClient = client;
            this.setShouldCloseZkClient(true);
        }
        if (this.zkClient instanceof ZKClient && !this.zkClient.isConnected()) {
            LOG.debug((Object)("Staring IZKClient " + this.zkClient));
            ((ZKClient)this.zkClient).start();
        }
        this.zkClient.waitForConnected(new Timespan(this.getMaximumConnectionTimeout()));
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() throws Exception {
        if (this.loadBalanceStrategy == null) {
            this.loadBalanceStrategy = this.getDefaultLoadBalanceStrategy();
        }
        if (this.loadBalanceStrategy.getGroup() == null) {
            this.loadBalanceStrategy.setGroup(this.getGroup());
        }
        return this.loadBalanceStrategy;
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy strategy) {
        this.loadBalanceStrategy = strategy;
    }

    public void setShouldCloseZkClient(boolean closeZkClient) {
        this.shouldCloseZkClient = closeZkClient;
    }

    public boolean isShouldCloseZkClient() {
        return this.shouldCloseZkClient;
    }

    public long getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(long maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    public ServerAddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void setAddressResolver(ServerAddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    public String getZooKeeperUrl() {
        return this.zooKeeperUrl;
    }

    public void setZooKeeperUrl(String zooKeeperUrl) {
        this.zooKeeperUrl = zooKeeperUrl;
    }

    public String getZooKeeperPassword() {
        return this.zooKeeperPassword;
    }

    public void setZooKeeperPassword(String zooKeeperPassword) {
        this.zooKeeperPassword = zooKeeperPassword;
    }

    public void initComplete() {
    }

    public void preShutdown() {
    }

    public void postShutdown() {
        try {
            this.destroy();
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot shut down the zkClient due to " + e));
        }
    }
}

