/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.fusesource.fabric.cxf.ServerAddressResolver;
import org.fusesource.fabric.groups.Group;

public class FabricServerListener
implements ServerLifeCycleListener {
    private static final transient Log LOG = LogFactory.getLog(FabricServerListener.class);
    private final Group group;
    private String eid;
    private ServerAddressResolver addressResolver;

    public FabricServerListener(Group group, ServerAddressResolver addressResolver) {
        this.group = group;
        this.addressResolver = addressResolver;
    }

    public FabricServerListener(Group group) {
        this(group, null);
    }

    public void startServer(Server server) {
        String address = this.getFullAddress(server.getEndpoint().getEndpointInfo().getAddress());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is start with address " + address));
        }
        try {
            this.eid = this.group.join(address.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            LOG.warn((Object)("Cannot bind the address " + address + " to the group, due to "), (Throwable)ex);
        }
    }

    public void stopServer(Server server) {
        String address = this.getFullAddress(server.getEndpoint().getEndpointInfo().getAddress());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is stopped with address " + address));
        }
        this.group.leave(this.eid);
    }

    public String getFullAddress(String address) {
        if (this.addressResolver != null) {
            return this.addressResolver.getFullAddress(address);
        }
        return address;
    }
}

