/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi;

import java.util.concurrent.TimeUnit;
import org.fusesource.fabric.dosgi.impl.Manager;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
implements LifecycleListener {
    private BundleContext bundleContext;
    private Manager manager;
    private String uri;
    private long timeout = TimeUnit.MINUTES.toMillis(5L);
    private ServiceReference reference;
    private IZKClient zookeeper;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void destroy() {
        this.destroyManager();
        if (this.reference != null) {
            ServiceReference ref = this.reference;
            this.reference = null;
            this.zookeeper = null;
            this.bundleContext.ungetService(ref);
        }
    }

    protected void destroyManager() {
        if (this.manager != null) {
            Manager mgr = this.manager;
            this.manager = null;
            mgr.destroy();
        }
    }

    public void registerZooKeeper(ServiceReference ref) {
        this.destroy();
        try {
            this.reference = ref;
            this.zookeeper = (IZKClient)this.bundleContext.getService(this.reference);
            this.zookeeper.registerListener((LifecycleListener)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start DOSGi service: " + e.getMessage(), e);
        }
    }

    public void unregisterZooKeeper(ServiceReference reference) {
        this.destroy();
    }

    public void onConnected() {
        this.destroyManager();
        try {
            this.manager = new Manager(this.bundleContext, this.zookeeper, this.uri, this.timeout);
            this.manager.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start DOSGi service: " + e.getMessage(), e);
        }
    }

    public void onDisconnected() {
        this.destroyManager();
    }
}

