/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.UnregisteredDatanodeException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNodeMXBean;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.UpgradeManagerDatanode;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeInstrumentation;
import org.apache.hadoop.hdfs.server.datanode.web.resources.DatanodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.StreamFile;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockMetaDataInfo;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.jetty.Connector;
import org.mortbay.util.ajax.JSON;

public class DataNode
extends Configured
implements InterDatanodeProtocol,
ClientDatanodeProtocol,
FSConstants,
Runnable,
DataNodeMXBean {
    public static final Log LOG = LogFactory.getLog(DataNode.class);
    public static final String DN_CLIENTTRACE_FORMAT = "src: %s, dest: %s, bytes: %s, op: %s, cliID: %s, offset: %s, srvID: %s, blockid: %s, duration: %s";
    static final Log ClientTraceLog;
    public DatanodeProtocol namenode = null;
    public FSDatasetInterface data = null;
    public DatanodeRegistration dnRegistration = null;
    volatile boolean shouldRun = true;
    private LinkedList<Block> receivedBlockList = new LinkedList();
    private final Map<Block, Block> ongoingRecovery = new HashMap<Block, Block>();
    private LinkedList<String> delHints = new LinkedList();
    public static final String EMPTY_DEL_HINT = "";
    AtomicInteger xmitsInProgress = new AtomicInteger();
    Daemon dataXceiverServer = null;
    ThreadGroup threadGroup = null;
    long blockReportInterval;
    long lastBlockReport = 0L;
    boolean resetBlockReportTime = true;
    long initialBlockReportDelay = 0L;
    long lastHeartbeat = 0L;
    long heartBeatInterval;
    private DataStorage storage = null;
    private HttpServer infoServer = null;
    DataNodeInstrumentation myMetrics;
    private static InetSocketAddress nameNodeAddr;
    private InetSocketAddress selfAddr;
    private static DataNode datanodeObject;
    private Thread dataNodeThread = null;
    String machineName;
    private static String dnThreadName;
    int socketTimeout;
    int socketWriteTimeout = 0;
    boolean transferToAllowed = true;
    int writePacketSize = 0;
    private boolean supportAppends;
    boolean isBlockTokenEnabled;
    BlockTokenSecretManager blockTokenSecretManager;
    boolean isBlockTokenInitialized = false;
    final String userWithLocalPathAccess;
    int artificialBlockReceivedDelay = 0;
    public DataBlockScanner blockScanner = null;
    public Daemon blockScannerThread = null;
    private static final Random R;
    public static final String DATA_DIR_KEY = "dfs.data.dir";
    public static final String DATA_DIR_PERMISSION_KEY = "dfs.datanode.data.dir.perm";
    private static final String DEFAULT_DATA_DIR_PERMISSION = "755";
    private static final long LATE_BLOCK_REPORT_WARN_THRESHOLD = 600000L;
    private static final long LATE_BLOCK_REPORT_INFO_THRESHOLD = 180000L;
    public Server ipcServer;
    private SecureDataNodeStarter.SecureResources secureResources = null;
    private ObjectName mxBean = null;
    UpgradeManagerDatanode upgradeManager = new UpgradeManagerDatanode(this);
    public static final int PKT_HEADER_LEN = 21;

    @Deprecated
    public static InetSocketAddress createSocketAddr(String target) throws IOException {
        return NetUtils.createSocketAddr(target);
    }

    static long now() {
        return System.currentTimeMillis();
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs) throws IOException {
        this(conf, dataDirs, null);
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs, SecureDataNodeStarter.SecureResources resources) throws IOException {
        super(conf);
        SecurityUtil.login(conf, "dfs.datanode.keytab.file", "dfs.datanode.kerberos.principal");
        datanodeObject = this;
        this.supportAppends = conf.getBoolean("dfs.support.append", false);
        this.userWithLocalPathAccess = conf.get("dfs.block.local-path-access.user");
        try {
            this.startDataNode(conf, dataDirs, resources);
        }
        catch (IOException ie) {
            this.shutdown();
            throw ie;
        }
    }

    void startDataNode(Configuration conf, AbstractList<File> dataDirs, SecureDataNodeStarter.SecureResources resources) throws IOException {
        ServerSocket ss;
        if (UserGroupInformation.isSecurityEnabled() && resources == null) {
            throw new RuntimeException("Cannot start secure cluster without privileged resources.");
        }
        this.secureResources = resources;
        if (conf.get("slave.host.name") != null) {
            this.machineName = conf.get("slave.host.name");
        }
        if (this.machineName == null) {
            this.machineName = DNS.getDefaultHost(conf.get("dfs.datanode.dns.interface", "default"), conf.get("dfs.datanode.dns.nameserver", "default"));
        }
        InetSocketAddress nameNodeAddr = NameNode.getServiceAddress(conf, true);
        this.socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
        this.socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.transferToAllowed = conf.getBoolean("dfs.datanode.transferTo.allowed", true);
        this.writePacketSize = conf.getInt("dfs.write.packet.size", 65536);
        InetSocketAddress socAddr = DataNode.getStreamingAddr(conf);
        int tmpPort = socAddr.getPort();
        this.storage = new DataStorage();
        this.dnRegistration = new DatanodeRegistration(this.machineName + ":" + tmpPort);
        this.namenode = (DatanodeProtocol)RPC.waitForProxy(DatanodeProtocol.class, 25L, nameNodeAddr, conf);
        NamespaceInfo nsInfo = this.handshake();
        HdfsConstants.StartupOption startOpt = DataNode.getStartupOption(conf);
        assert (startOpt != null) : "Startup option must be set.";
        boolean simulatedFSDataset = conf.getBoolean("dfs.datanode.simulateddatastorage", false);
        if (simulatedFSDataset) {
            DataNode.setNewStorageID(this.dnRegistration);
            this.dnRegistration.storageInfo.layoutVersion = -32;
            this.dnRegistration.storageInfo.namespaceID = nsInfo.namespaceID;
            conf.set("StorageId", this.dnRegistration.getStorageID());
            try {
                this.data = (FSDatasetInterface)ReflectionUtils.newInstance(Class.forName("org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset"), conf);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
        } else {
            this.storage.recoverTransitionRead(nsInfo, dataDirs, startOpt);
            this.dnRegistration.setStorageInfo(this.storage);
            this.data = new FSDataset(this.storage, conf);
        }
        this.registerMXBean(conf);
        this.artificialBlockReceivedDelay = conf.getInt("dfs.datanode.artificialBlockReceivedDelay", 0);
        if (this.secureResources == null) {
            ss = this.socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
            Server.bind(ss, socAddr, 0);
        } else {
            ss = resources.getStreamingSocket();
        }
        ss.setReceiveBufferSize(131072);
        tmpPort = ss.getLocalPort();
        this.selfAddr = new InetSocketAddress(ss.getInetAddress().getHostAddress(), tmpPort);
        this.dnRegistration.setName(this.machineName + ":" + tmpPort);
        LOG.info((Object)("Opened info server at " + tmpPort));
        this.threadGroup = new ThreadGroup("dataXceiverServer");
        this.dataXceiverServer = new Daemon(this.threadGroup, new DataXceiverServer(ss, conf, this));
        this.threadGroup.setDaemon(true);
        this.blockReportInterval = conf.getLong("dfs.blockreport.intervalMsec", 3600000L);
        this.initialBlockReportDelay = conf.getLong("dfs.blockreport.initialDelay", 0L) * 1000L;
        if (this.initialBlockReportDelay >= this.blockReportInterval) {
            this.initialBlockReportDelay = 0L;
            LOG.info((Object)"dfs.blockreport.initialDelay is greater than dfs.blockreport.intervalMsec. Setting initial delay to 0 msec:");
        }
        this.heartBeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        DataNode.nameNodeAddr = nameNodeAddr;
        String reason = null;
        if (conf.getInt("dfs.datanode.scan.period.hours", 0) < 0) {
            reason = "verification is turned off by configuration";
        } else if (!(this.data instanceof FSDataset)) {
            reason = "verifcation is supported only with FSDataset";
        }
        if (reason == null) {
            this.blockScanner = new DataBlockScanner(this, (FSDataset)this.data, conf);
        } else {
            LOG.info((Object)("Periodic Block Verification is disabled because " + reason + "."));
        }
        InetSocketAddress infoSocAddr = DataNode.getInfoAddr(conf);
        String infoHost = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        HttpServer httpServer = this.secureResources == null ? new HttpServer("datanode", infoHost, tmpInfoPort, tmpInfoPort == 0, conf, SecurityUtil.getAdminAcls(conf, "dfs.cluster.administrators")) : (this.infoServer = new HttpServer("datanode", infoHost, tmpInfoPort, tmpInfoPort == 0, conf, SecurityUtil.getAdminAcls(conf, "dfs.cluster.administrators"), (Connector)this.secureResources.getListener()));
        if (conf.getBoolean("dfs.https.enable", false)) {
            boolean needClientAuth = conf.getBoolean("dfs.https.need.client.auth", false);
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr(conf.get("dfs.datanode.https.address", infoHost + ":" + 0));
            Configuration sslConf = new Configuration(false);
            sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
            this.infoServer.addSslListener(secInfoSocAddr, sslConf, needClientAuth);
        }
        this.infoServer.addInternalServlet(null, "/streamFile/*", StreamFile.class);
        this.infoServer.addInternalServlet(null, "/getFileChecksum/*", FileChecksumServlets.GetServlet.class);
        this.infoServer.setAttribute("datanode", this);
        this.infoServer.setAttribute("datanode.blockScanner", this.blockScanner);
        this.infoServer.setAttribute("current.conf", conf);
        this.infoServer.addServlet(null, "/blockScannerReport", DataBlockScanner.Servlet.class);
        if (WebHdfsFileSystem.isEnabled(conf, LOG)) {
            this.infoServer.addJerseyResourcePackage(DatanodeWebHdfsMethods.class.getPackage().getName() + ";" + Param.class.getPackage().getName(), "/webhdfs/v1/*");
        }
        this.infoServer.start();
        this.dnRegistration.setInfoPort(this.infoServer.getPort());
        this.myMetrics = DataNodeInstrumentation.create(conf, this.dnRegistration.getStorageID());
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            ServiceAuthorizationManager.refresh(conf, new HDFSPolicyProvider());
        }
        this.blockTokenSecretManager = new BlockTokenSecretManager(false, 0L, 0L);
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr(conf.get("dfs.datanode.ipc.address"));
        this.ipcServer = RPC.getServer(this, ipcAddr.getHostName(), ipcAddr.getPort(), conf.getInt("dfs.datanode.handler.count", 3), false, conf, this.blockTokenSecretManager);
        this.dnRegistration.setIpcPort(this.ipcServer.getListenerAddress().getPort());
        LOG.info((Object)("dnRegistration = " + this.dnRegistration));
    }

    void registerMXBean(Configuration conf) {
        this.mxBean = MBeans.register("DataNode", "DataNodeInfo", this);
    }

    public void unRegisterMXBean() {
        if (this.mxBean != null) {
            MBeans.unregister(this.mxBean);
        }
    }

    public static InetSocketAddress getInfoAddr(Configuration conf) {
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.datanode.info.bindAddress", "dfs.datanode.info.port", "dfs.datanode.http.address");
        return NetUtils.createSocketAddr(infoAddr);
    }

    protected Socket newSocket() throws IOException {
        return this.socketWriteTimeout > 0 ? SocketChannel.open().socket() : new Socket();
    }

    private NamespaceInfo handshake() throws IOException {
        NamespaceInfo nsInfo = new NamespaceInfo();
        while (this.shouldRun) {
            try {
                nsInfo = this.namenode.versionRequest();
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        String errorMsg = null;
        if (!nsInfo.getBuildVersion().equals(Storage.getBuildVersion())) {
            errorMsg = "Incompatible build versions: namenode BV = " + nsInfo.getBuildVersion() + "; datanode BV = " + Storage.getBuildVersion();
            LOG.fatal((Object)errorMsg);
            this.notifyNamenode(0, errorMsg);
            throw new IOException(errorMsg);
        }
        assert (-32 == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.Expected: -32 actual " + nsInfo.getLayoutVersion();
        return nsInfo;
    }

    public static DataNode getDataNode() {
        return datanodeObject;
    }

    public static InterDatanodeProtocol createInterDataNodeProtocolProxy(DatanodeID datanodeid, final Configuration conf, final int socketTimeout) throws IOException {
        final InetSocketAddress addr = NetUtils.createSocketAddr(datanodeid.getHost() + ":" + datanodeid.getIpcPort());
        if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
            InterDatanodeProtocol.LOG.info((Object)("InterDatanodeProtocol addr=" + addr));
        }
        UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        try {
            return loginUgi.doAs(new PrivilegedExceptionAction<InterDatanodeProtocol>(){

                @Override
                public InterDatanodeProtocol run() throws IOException {
                    return (InterDatanodeProtocol)RPC.getProxy(InterDatanodeProtocol.class, 3L, addr, conf, socketTimeout);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getMessage());
        }
    }

    public InetSocketAddress getNameNodeAddr() {
        return nameNodeAddr;
    }

    public InetSocketAddress getSelfAddr() {
        return this.selfAddr;
    }

    DataNodeInstrumentation getMetrics() {
        return this.myMetrics;
    }

    public String getNamenode() {
        return "<namenode>";
    }

    public static void setNewStorageID(DatanodeRegistration dnReg) {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP("default");
        }
        catch (UnknownHostException ignored) {
            LOG.warn((Object)"Could not find ip address of \"default\" inteface.");
        }
        int rand = 0;
        try {
            rand = SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)"Could not use SecureRandom");
            rand = R.nextInt(Integer.MAX_VALUE);
        }
        dnReg.storageID = "DS-" + rand + "-" + ip + "-" + dnReg.getPort() + "-" + System.currentTimeMillis();
    }

    private void register() throws IOException {
        if (this.dnRegistration.getStorageID().equals(EMPTY_DEL_HINT)) {
            DataNode.setNewStorageID(this.dnRegistration);
        }
        while (this.shouldRun) {
            try {
                this.dnRegistration.name = this.machineName + ":" + this.dnRegistration.getPort();
                this.dnRegistration = this.namenode.register(this.dnRegistration);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        assert (EMPTY_DEL_HINT.equals(this.storage.getStorageID()) && !EMPTY_DEL_HINT.equals(this.dnRegistration.getStorageID()) || this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) : "New storageID can be assigned only if data-node is not formatted";
        if (this.storage.getStorageID().equals(EMPTY_DEL_HINT)) {
            this.storage.setStorageID(this.dnRegistration.getStorageID());
            this.storage.writeAll();
            LOG.info((Object)("New storage id " + this.dnRegistration.getStorageID() + " is assigned to data-node " + this.dnRegistration.getName()));
        }
        if (!this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) {
            throw new IOException("Inconsistent storage IDs. Name-node returned " + this.dnRegistration.getStorageID() + ". Expecting " + this.storage.getStorageID());
        }
        if (!this.isBlockTokenInitialized) {
            ExportedBlockKeys keys = this.dnRegistration.exportedKeys;
            this.isBlockTokenEnabled = keys.isBlockTokenEnabled();
            if (this.isBlockTokenEnabled) {
                long blockKeyUpdateInterval = keys.getKeyUpdateInterval();
                long blockTokenLifetime = keys.getTokenLifetime();
                LOG.info((Object)("Block token params received from NN: keyUpdateInterval=" + blockKeyUpdateInterval / 60000L + " min(s), tokenLifetime=" + blockTokenLifetime / 60000L + " min(s)"));
                this.blockTokenSecretManager.setTokenLifetime(blockTokenLifetime);
            }
            this.isBlockTokenInitialized = true;
        }
        if (this.isBlockTokenEnabled) {
            this.blockTokenSecretManager.setKeys(this.dnRegistration.exportedKeys);
            this.dnRegistration.exportedKeys = ExportedBlockKeys.DUMMY_KEYS;
        }
        if (this.supportAppends) {
            Block[] bbwReport = this.data.getBlocksBeingWrittenReport();
            long[] blocksBeingWritten = BlockListAsLongs.convertToArrayLongs(bbwReport);
            this.namenode.blocksBeingWrittenReport(this.dnRegistration, blocksBeingWritten);
        }
        this.data.requestAsyncBlockReport();
        this.scheduleBlockReport(this.initialBlockReportDelay);
    }

    public void shutdown() {
        if (!this.shouldRun) {
            return;
        }
        this.shouldRun = false;
        this.unRegisterMXBean();
        if (this.infoServer != null) {
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception shutting down DataNode", (Throwable)e);
            }
        }
        if (this.ipcServer != null) {
            this.ipcServer.stop();
        }
        if (this.dataXceiverServer != null) {
            ((DataXceiverServer)this.dataXceiverServer.getRunnable()).kill();
            this.dataXceiverServer.interrupt();
            if (this.threadGroup != null) {
                while (true) {
                    this.threadGroup.interrupt();
                    LOG.info((Object)("Waiting for threadgroup to exit, active threads is " + this.threadGroup.activeCount()));
                    if (this.threadGroup.activeCount() == 0) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            try {
                this.dataXceiverServer.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        RPC.stopProxy(this.namenode);
        if (this.upgradeManager != null) {
            this.upgradeManager.shutdownUpgrade();
        }
        if (this.blockScannerThread != null) {
            this.blockScannerThread.interrupt();
            try {
                this.blockScannerThread.join(3600000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException ie) {
                // empty catch block
            }
        }
        if (this.dataNodeThread != null) {
            this.dataNodeThread.interrupt();
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.myMetrics != null) {
            this.myMetrics.shutdown();
        }
    }

    protected void checkDiskError(Exception e) throws IOException {
        LOG.warn((Object)"checkDiskError: exception: ", (Throwable)e);
        if (e.getMessage() != null && e.getMessage().startsWith("No space left on device")) {
            throw new DiskChecker.DiskOutOfSpaceException("No space left on device");
        }
        this.checkDiskError();
    }

    protected void checkDiskError() {
        try {
            this.data.checkDataDir();
        }
        catch (DiskChecker.DiskErrorException de) {
            this.handleDiskError(de.getMessage());
        }
    }

    private void notifyNamenode(int dpCode, String msg) {
        try {
            this.namenode.errorReport(this.dnRegistration, dpCode, msg);
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleDiskError(String errMsgr) {
        boolean hasEnoughResource = this.data.hasEnoughResource();
        LOG.warn((Object)("DataNode.handleDiskError: Keep Running: " + hasEnoughResource));
        int dp_error = 1;
        if (!hasEnoughResource) {
            dp_error = 3;
        }
        this.notifyNamenode(dp_error, errMsgr);
        if (hasEnoughResource) {
            this.scheduleBlockReport(0L);
            return;
        }
        LOG.warn((Object)("DataNode is shutting down.\n" + errMsgr));
        this.shouldRun = false;
    }

    int getXceiverCount() {
        return this.threadGroup == null ? 0 : this.threadGroup.activeCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws Exception {
        LOG.info((Object)("using BLOCKREPORT_INTERVAL of " + this.blockReportInterval + "msec" + " Initial delay: " + this.initialBlockReportDelay + "msec"));
        while (this.shouldRun) {
            try {
                LinkedList<String> linkedList;
                long startTime = DataNode.now();
                if (startTime - this.lastHeartbeat > this.heartBeatInterval) {
                    this.lastHeartbeat = startTime;
                    DatanodeCommand[] cmds = this.namenode.sendHeartbeat(this.dnRegistration, this.data.getCapacity(), this.data.getDfsUsed(), this.data.getRemaining(), this.xmitsInProgress.get(), this.getXceiverCount());
                    this.myMetrics.addHeartBeat(DataNode.now() - startTime);
                    if (!this.processCommand(cmds)) continue;
                }
                Block[] blockArray = null;
                String[] delHintArray = null;
                LinkedList<Block> linkedList2 = this.receivedBlockList;
                synchronized (linkedList2) {
                    linkedList = this.delHints;
                    synchronized (linkedList) {
                        int numBlocks = this.receivedBlockList.size();
                        if (numBlocks > 0) {
                            if (numBlocks != this.delHints.size()) {
                                LOG.warn((Object)"Panic: receiveBlockList and delHints are not of the same length");
                            }
                            blockArray = this.receivedBlockList.toArray(new Block[numBlocks]);
                            delHintArray = this.delHints.toArray(new String[numBlocks]);
                        }
                    }
                }
                if (blockArray != null) {
                    if (delHintArray == null || delHintArray.length != blockArray.length) {
                        LOG.warn((Object)"Panic: block array & delHintArray are not the same");
                    }
                    this.namenode.blockReceived(this.dnRegistration, blockArray, delHintArray);
                    linkedList2 = this.receivedBlockList;
                    synchronized (linkedList2) {
                        linkedList = this.delHints;
                        synchronized (linkedList) {
                            for (int i = 0; i < blockArray.length; ++i) {
                                this.receivedBlockList.remove(blockArray[i]);
                                this.delHints.remove(delHintArray[i]);
                            }
                        }
                    }
                }
                if (startTime - this.lastBlockReport > this.blockReportInterval) {
                    if (this.data.isAsyncBlockReportReady()) {
                        long brCreateStartTime = DataNode.now();
                        Block[] bReport = this.data.retrieveAsyncBlockReport();
                        long brSendStartTime = DataNode.now();
                        DatanodeCommand cmd = this.namenode.blockReport(this.dnRegistration, BlockListAsLongs.convertToArrayLongs(bReport));
                        long brSendCost = DataNode.now() - brSendStartTime;
                        long brCreateCost = brSendStartTime - brCreateStartTime;
                        this.myMetrics.addBlockReport(brSendCost);
                        LOG.info((Object)("BlockReport of " + bReport.length + " blocks took " + brCreateCost + " msec to generate and " + brSendCost + " msecs for RPC and NN processing"));
                        if (this.resetBlockReportTime) {
                            this.lastBlockReport = startTime - (long)R.nextInt((int)this.blockReportInterval);
                            this.resetBlockReportTime = false;
                        } else {
                            this.lastBlockReport += (DataNode.now() - this.lastBlockReport) / this.blockReportInterval * this.blockReportInterval;
                        }
                        this.processCommand(cmd);
                    } else {
                        this.data.requestAsyncBlockReport();
                        if (this.lastBlockReport > 0L) {
                            long waitingFor = startTime - this.lastBlockReport - this.blockReportInterval;
                            String msg = "Block report is due, and been waiting for it for " + waitingFor / 1000L + " seconds...";
                            if (waitingFor > 600000L) {
                                LOG.warn((Object)msg);
                            } else if (waitingFor > 180000L) {
                                LOG.info((Object)msg);
                            } else if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)msg);
                            }
                        }
                    }
                }
                if (this.blockScanner != null && this.blockScannerThread == null && this.upgradeManager.isUpgradeCompleted()) {
                    LOG.info((Object)"Starting Periodic block scanner.");
                    this.blockScannerThread = new Daemon(this.blockScanner);
                    this.blockScannerThread.start();
                }
                long waitTime = this.heartBeatInterval - (System.currentTimeMillis() - this.lastHeartbeat);
                LinkedList<Block> linkedList3 = this.receivedBlockList;
                synchronized (linkedList3) {
                    if (waitTime > 0L && this.receivedBlockList.size() == 0) {
                        try {
                            this.receivedBlockList.wait(waitTime);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        this.delayBeforeBlockReceived();
                    }
                }
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredDatanodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn((Object)("DataNode is shutting down: " + StringUtils.stringifyException(re)));
                    this.shutdown();
                    return;
                }
                LOG.warn((Object)StringUtils.stringifyException(re));
            }
            catch (IOException e) {
                LOG.warn((Object)StringUtils.stringifyException(e));
            }
        }
    }

    private void delayBeforeBlockReceived() {
        if (this.artificialBlockReceivedDelay > 0 && !this.receivedBlockList.isEmpty()) {
            try {
                long sleepFor = R.nextInt(this.artificialBlockReceivedDelay);
                LOG.debug((Object)("DataNode " + this.dnRegistration + " sleeping for " + "artificial delay: " + sleepFor + " ms"));
                Thread.sleep(sleepFor);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean processCommand(DatanodeCommand[] cmds) {
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                try {
                    if (!this.processCommand(cmd)) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error processing datanode Command", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    private boolean processCommand(DatanodeCommand cmd) throws IOException {
        if (cmd == null) {
            return true;
        }
        BlockCommand bcmd = cmd instanceof BlockCommand ? (BlockCommand)cmd : null;
        switch (cmd.getAction()) {
            case 1: {
                this.transferBlocks(bcmd.getBlocks(), bcmd.getTargets());
                this.myMetrics.incrBlocksReplicated(bcmd.getBlocks().length);
                break;
            }
            case 2: {
                Block[] toDelete = bcmd.getBlocks();
                try {
                    if (this.blockScanner != null) {
                        this.blockScanner.deleteBlocks(toDelete);
                    }
                    this.data.invalidate(toDelete);
                }
                catch (IOException e) {
                    this.checkDiskError();
                    throw e;
                }
                this.myMetrics.incrBlocksRemoved(toDelete.length);
                break;
            }
            case 3: {
                this.shutdown();
                return false;
            }
            case 4: {
                LOG.info((Object)"DatanodeCommand action: DNA_REGISTER");
                if (!this.shouldRun) break;
                this.register();
                break;
            }
            case 5: {
                this.storage.finalizeUpgrade();
                break;
            }
            case 101: {
                this.processDistributedUpgradeCommand((UpgradeCommand)cmd);
                break;
            }
            case 6: {
                this.recoverBlocks(bcmd.getBlocks(), bcmd.getTargets());
                break;
            }
            case 7: {
                LOG.info((Object)"DatanodeCommand action: DNA_ACCESSKEYUPDATE");
                if (!this.isBlockTokenEnabled) break;
                this.blockTokenSecretManager.setKeys(((KeyUpdateCommand)cmd).getExportedKeys());
                break;
            }
            case 8: {
                long bandwidth;
                LOG.info((Object)"DatanodeCommand action: DNA_BALANCERBANDWIDTHUPDATE");
                int vsn = ((BalancerBandwidthCommand)cmd).getBalancerBandwidthVersion();
                if (vsn < 1 || (bandwidth = ((BalancerBandwidthCommand)cmd).getBalancerBandwidthValue()) <= 0L) break;
                DataXceiverServer dxcs = (DataXceiverServer)this.dataXceiverServer.getRunnable();
                dxcs.balanceThrottler.setBandwidth(bandwidth);
                break;
            }
            default: {
                LOG.warn((Object)("Unknown DatanodeCommand action: " + cmd.getAction()));
            }
        }
        return true;
    }

    private void processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        assert (this.upgradeManager != null) : "DataNode.upgradeManager is null.";
        this.upgradeManager.processUpgradeCommand(comm);
    }

    private void startDistributedUpgradeIfNeeded() throws IOException {
        UpgradeManagerDatanode um = DataNode.getDataNode().upgradeManager;
        assert (um != null) : "DataNode.upgradeManager is null.";
        if (!um.getUpgradeState()) {
            return;
        }
        um.setUpgradeState(false, um.getUpgradeVersion());
        um.startUpgrade();
    }

    private void transferBlock(Block block, DatanodeInfo[] xferTargets) throws IOException {
        if (!this.data.isValidBlock(block)) {
            String errStr = "Can't send invalid block " + block;
            LOG.info((Object)errStr);
            this.notifyNamenode(2, errStr);
            return;
        }
        long onDiskLength = this.data.getLength(block);
        if (block.getNumBytes() > onDiskLength) {
            this.namenode.reportBadBlocks(new LocatedBlock[]{new LocatedBlock(block, new DatanodeInfo[]{new DatanodeInfo(this.dnRegistration)})});
            LOG.info((Object)("Can't replicate block " + block + " because on-disk length " + onDiskLength + " is shorter than NameNode recorded length " + block.getNumBytes()));
            return;
        }
        int numTargets = xferTargets.length;
        if (numTargets > 0) {
            if (LOG.isInfoEnabled()) {
                StringBuilder xfersBuilder = new StringBuilder();
                for (int i = 0; i < numTargets; ++i) {
                    xfersBuilder.append(xferTargets[i].getName());
                    xfersBuilder.append(" ");
                }
                LOG.info((Object)(this.dnRegistration + " Starting thread to transfer block " + block + " to " + xfersBuilder));
            }
            new Daemon(new DataTransfer(xferTargets, block, this)).start();
        }
    }

    private void transferBlocks(Block[] blocks, DatanodeInfo[][] xferTargets) {
        for (int i = 0; i < blocks.length; ++i) {
            try {
                this.transferBlock(blocks[i], xferTargets[i]);
                continue;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed to transfer block " + blocks[i]), (Throwable)ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNamenodeReceivedBlock(Block block, String delHint) {
        if (block == null || delHint == null) {
            throw new IllegalArgumentException(block == null ? "Block is null" : "delHint is null");
        }
        LinkedList<Block> linkedList = this.receivedBlockList;
        synchronized (linkedList) {
            LinkedList<String> linkedList2 = this.delHints;
            synchronized (linkedList2) {
                this.receivedBlockList.add(block);
                this.delHints.add(delHint);
                this.receivedBlockList.notifyAll();
            }
        }
    }

    @Override
    public void run() {
        LOG.info((Object)(this.dnRegistration + "In DataNode.run, data = " + this.data));
        this.dataXceiverServer.start();
        this.ipcServer.start();
        while (this.shouldRun) {
            try {
                this.startDistributedUpgradeIfNeeded();
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception: " + StringUtils.stringifyException(ex)));
                if (!this.shouldRun) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        LOG.info((Object)(this.dnRegistration + ":Finishing DataNode in: " + this.data));
        this.shutdown();
    }

    public static void runDatanodeDaemon(DataNode dn) throws IOException {
        if (dn != null) {
            dn.register();
            dn.dataNodeThread = new Thread((Runnable)dn, dnThreadName);
            dn.dataNodeThread.setDaemon(true);
            dn.dataNodeThread.start();
        }
    }

    static boolean isDatanodeUp(DataNode dn) {
        return dn.dataNodeThread != null && dn.dataNodeThread.isAlive();
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.instantiateDataNode(args, conf, null);
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        if (conf == null) {
            conf = new Configuration();
        }
        if (!DataNode.parseArguments(args, conf)) {
            DataNode.printUsage();
            return null;
        }
        if (conf.get("dfs.network.script") != null) {
            LOG.error((Object)"This configuration for rack identification is not supported anymore. RackID resolution is handled by the NameNode.");
            System.exit(-1);
        }
        String[] dataDirs = conf.getStrings(DATA_DIR_KEY);
        dnThreadName = "DataNode: [" + StringUtils.arrayToString(dataDirs) + "]";
        DefaultMetricsSystem.initialize("DataNode");
        return DataNode.makeInstance(dataDirs, conf, resources);
    }

    public static DataNode createDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.createDataNode(args, conf, null);
    }

    public static DataNode createDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        DataNode dn = DataNode.instantiateDataNode(args, conf, resources);
        DataNode.runDatanodeDaemon(dn);
        return dn;
    }

    void join() {
        if (this.dataNodeThread != null) {
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static DataNode makeInstance(String[] dataDirs, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        UserGroupInformation.setConfiguration(conf);
        LocalFileSystem localFS = FileSystem.getLocal(conf);
        ArrayList<File> dirs = new ArrayList<File>();
        FsPermission dataDirPermission = new FsPermission(conf.get(DATA_DIR_PERMISSION_KEY, DEFAULT_DATA_DIR_PERMISSION));
        for (String dir : dataDirs) {
            try {
                DiskChecker.checkDir(localFS, new Path(dir), dataDirPermission);
                dirs.add(new File(dir));
            }
            catch (IOException e) {
                LOG.warn((Object)("Invalid directory in dfs.data.dir: " + e.getMessage()));
            }
        }
        if (dirs.size() > 0) {
            return new DataNode(conf, dirs, resources);
        }
        LOG.error((Object)"All directories in dfs.data.dir are invalid.");
        return null;
    }

    public String toString() {
        return "DataNode{data=" + this.data + ", localName='" + this.dnRegistration.getName() + "'" + ", storageID='" + this.dnRegistration.getStorageID() + "'" + ", xmitsInProgress=" + this.xmitsInProgress.get() + "}";
    }

    private static void printUsage() {
        System.err.println("Usage: java DataNode");
        System.err.println("           [-rollback]");
    }

    private static boolean parseArguments(String[] args, Configuration conf) {
        int argsLen = args == null ? 0 : args.length;
        HdfsConstants.StartupOption startOpt = HdfsConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if ("-r".equalsIgnoreCase(cmd) || "--rack".equalsIgnoreCase(cmd)) {
                LOG.error((Object)"-r, --rack arguments are not supported anymore. RackID resolution is handled by the NameNode.");
                System.exit(-1);
                continue;
            }
            if ("-rollback".equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.ROLLBACK;
                continue;
            }
            if ("-regular".equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.REGULAR;
                continue;
            }
            return false;
        }
        DataNode.setStartupOption(conf, startOpt);
        return true;
    }

    private static void setStartupOption(Configuration conf, HdfsConstants.StartupOption opt) {
        conf.set("dfs.datanode.startup", opt.toString());
    }

    static HdfsConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsConstants.StartupOption.valueOf(conf.get("dfs.datanode.startup", HdfsConstants.StartupOption.REGULAR.toString()));
    }

    public void scheduleBlockReport(long delay) {
        this.lastBlockReport = delay > 0L ? System.currentTimeMillis() - (this.blockReportInterval - (long)R.nextInt((int)delay)) : this.lastHeartbeat - this.blockReportInterval;
        this.resetBlockReportTime = true;
    }

    public FSDatasetInterface getFSDataset() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secureMain(String[] args, SecureDataNodeStarter.SecureResources resources) {
        try {
            StringUtils.startupShutdownMessage(DataNode.class, args, LOG);
            DataNode datanode = DataNode.createDataNode(args, null, resources);
            if (datanode != null) {
                datanode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
        finally {
            LOG.info((Object)"Exiting Datanode");
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        DataNode.secureMain(args, null);
    }

    @Override
    public BlockMetaDataInfo getBlockMetaDataInfo(Block block) throws IOException {
        Block stored;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("block=" + block));
        }
        if ((stored = this.data.getStoredBlock(block.getBlockId())) == null) {
            return null;
        }
        BlockMetaDataInfo info = new BlockMetaDataInfo(stored, this.blockScanner.getLastScanTime(stored));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getBlockMetaDataInfo successful block=" + stored + " length " + stored.getNumBytes() + " genstamp " + stored.getGenerationStamp()));
        }
        this.data.validateBlockMetadata(stored);
        return info;
    }

    @Override
    public BlockRecoveryInfo startBlockRecovery(Block block) throws IOException {
        return this.data.startBlockRecovery(block.getBlockId());
    }

    public Daemon recoverBlocks(final Block[] blocks, final DatanodeInfo[][] targets) {
        Daemon d = new Daemon(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < blocks.length; ++i) {
                    try {
                        DataNode.logRecoverBlock("NameNode", blocks[i], targets[i]);
                        DataNode.this.recoverBlock(blocks[i], false, targets[i], true);
                        continue;
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("recoverBlocks FAILED, blocks[" + i + "]=" + blocks[i]), (Throwable)e);
                    }
                }
            }
        });
        d.start();
        return d;
    }

    @Override
    public void updateBlock(Block oldblock, Block newblock, boolean finalize) throws IOException {
        LOG.info((Object)("oldblock=" + oldblock + "(length=" + oldblock.getNumBytes() + "), newblock=" + newblock + "(length=" + newblock.getNumBytes() + "), datanode=" + this.dnRegistration.getName()));
        this.data.updateBlock(oldblock, newblock);
        if (finalize) {
            this.data.finalizeBlockIfNeeded(newblock);
            this.myMetrics.incrBlocksWritten();
            this.notifyNamenodeReceivedBlock(newblock, EMPTY_DEL_HINT);
            LOG.info((Object)("Received block " + newblock + " of size " + newblock.getNumBytes() + " as part of lease recovery."));
        }
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterDatanodeProtocol.class.getName())) {
            return 3L;
        }
        if (protocol.equals(ClientDatanodeProtocol.class.getName())) {
            return 4L;
        }
        throw new IOException("Unknown protocol to " + this.getClass().getSimpleName() + ": " + protocol);
    }

    private void checkKerberosAuthMethod(String msg) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (UserGroupInformation.getCurrentUser().getAuthenticationMethod() != UserGroupInformation.AuthenticationMethod.KERBEROS) {
            throw new AccessControlException("Error in " + msg + ". Only " + "kerberos based authentication is allowed.");
        }
    }

    private void checkBlockLocalPathAccess() throws IOException {
        this.checkKerberosAuthMethod("getBlockLocalPathInfo()");
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!currentUser.equals(this.userWithLocalPathAccess)) {
            throw new AccessControlException("Can't continue with getBlockLocalPathInfo() authorization. The user " + currentUser + " is not allowed to call getBlockLocalPathInfo");
        }
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(Block block, Token<BlockTokenIdentifier> token) throws IOException {
        this.checkBlockLocalPathAccess();
        this.checkBlockToken(block, token, BlockTokenSecretManager.AccessMode.READ);
        BlockLocalPathInfo info = this.data.getBlockLocalPathInfo(block);
        if (LOG.isDebugEnabled()) {
            if (info != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("getBlockLocalPathInfo successful block=" + block + " blockfile " + info.getBlockPath() + " metafile " + info.getMetaPath()));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("getBlockLocalPathInfo for block=" + block + " returning null"));
            }
        }
        this.myMetrics.incrBlocksGetLocalPathInfo();
        return info;
    }

    private void checkBlockToken(Block block, Token<BlockTokenIdentifier> token, BlockTokenSecretManager.AccessMode accessMode) throws IOException {
        if (this.isBlockTokenEnabled && UserGroupInformation.isSecurityEnabled()) {
            BlockTokenIdentifier id = new BlockTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields(in);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Got: " + id.toString()));
            }
            this.blockTokenSecretManager.checkAccess(id, null, block, accessMode);
        }
    }

    private void checkBlockToken(Block block, BlockTokenSecretManager.AccessMode accessMode) throws IOException {
        if (this.isBlockTokenEnabled && UserGroupInformation.isSecurityEnabled()) {
            Set<TokenIdentifier> tokenIds = UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            if (tokenIds.size() != 1) {
                throw new IOException("Can't continue with authorization since " + tokenIds.size() + " BlockTokenIdentifier " + "is found.");
            }
            for (TokenIdentifier tokenId : tokenIds) {
                BlockTokenIdentifier id = (BlockTokenIdentifier)tokenId;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got: " + id.toString()));
                }
                this.blockTokenSecretManager.checkAccess(id, null, block, accessMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlock recoverBlock(Block block, boolean keepLength, DatanodeInfo[] targets, boolean closeFile) throws IOException {
        DatanodeID[] datanodeids = targets;
        Map<Block, Block> map = this.ongoingRecovery;
        synchronized (map) {
            Block tmp = new Block();
            tmp.set(block.getBlockId(), block.getNumBytes(), 1L);
            if (this.ongoingRecovery.get(tmp) != null) {
                String msg = "Block " + block + " is already being recovered, " + " ignoring this request to recover it.";
                LOG.info((Object)msg);
                throw new IOException(msg);
            }
            this.ongoingRecovery.put(block, block);
        }
        try {
            int errorCount = 0;
            int rbwCount = 0;
            int rwrCount = 0;
            ArrayList<BlockRecord> blockRecords = new ArrayList<BlockRecord>();
            for (DatanodeID id : datanodeids) {
                try {
                    DataNode datanode = this.dnRegistration.equals(id) ? this : DataNode.createInterDataNodeProtocolProxy(id, this.getConf(), this.socketTimeout);
                    BlockRecoveryInfo info = datanode.startBlockRecovery(block);
                    if (info == null) {
                        LOG.info((Object)("No block metadata found for block " + block + " on datanode " + id));
                        continue;
                    }
                    if (info.getBlock().getGenerationStamp() < block.getGenerationStamp()) {
                        LOG.info((Object)("Only old generation stamp " + info.getBlock().getGenerationStamp() + " found on datanode " + id + " (needed block=" + block + ")"));
                        continue;
                    }
                    blockRecords.add(new BlockRecord(id, datanode, info));
                    if (info.wasRecoveredOnStartup()) {
                        ++rwrCount;
                        continue;
                    }
                    ++rbwCount;
                }
                catch (IOException e) {
                    ++errorCount;
                    InterDatanodeProtocol.LOG.warn((Object)("Failed to getBlockMetaDataInfo for block (=" + block + ") from datanode (=" + id + ")"), (Throwable)e);
                }
            }
            boolean shouldRecoverRwrs = rbwCount == 0;
            ArrayList<BlockRecord> syncList = new ArrayList<BlockRecord>();
            long minlength = Long.MAX_VALUE;
            for (BlockRecord record : blockRecords) {
                BlockRecoveryInfo info = record.info;
                assert (info != null && info.getBlock().getGenerationStamp() >= block.getGenerationStamp());
                if (!shouldRecoverRwrs && info.wasRecoveredOnStartup()) {
                    LOG.info((Object)("Not recovering replica " + record + " since it was recovered on " + "startup and we have better replicas"));
                    continue;
                }
                if (keepLength) {
                    if (info.getBlock().getNumBytes() != block.getNumBytes()) continue;
                    syncList.add(record);
                    continue;
                }
                syncList.add(record);
                if (info.getBlock().getNumBytes() >= minlength) continue;
                minlength = info.getBlock().getNumBytes();
            }
            if (syncList.isEmpty() && errorCount > 0) {
                throw new IOException("All datanodes failed: block=" + block + ", datanodeids=" + Arrays.asList(datanodeids));
            }
            if (!keepLength) {
                block.setNumBytes(minlength);
            }
            LocatedBlock locatedBlock = this.syncBlock(block, syncList, targets, closeFile);
            return locatedBlock;
        }
        finally {
            Map<Block, Block> map2 = this.ongoingRecovery;
            synchronized (map2) {
                this.ongoingRecovery.remove(block);
            }
        }
    }

    private LocatedBlock syncBlock(Block block, List<BlockRecord> syncList, DatanodeInfo[] targets, boolean closeFile) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("block=" + block + ", (length=" + block.getNumBytes() + "), syncList=" + syncList + ", closeFile=" + closeFile));
        }
        if (syncList.isEmpty()) {
            this.namenode.commitBlockSynchronization(block, 0L, 0L, closeFile, true, DatanodeID.EMPTY_ARRAY);
            LocatedBlock b = new LocatedBlock(block, targets);
            if (this.isBlockTokenEnabled) {
                b.setBlockToken(this.blockTokenSecretManager.generateToken(null, b.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
            }
            return b;
        }
        ArrayList<DatanodeID> successList = new ArrayList<DatanodeID>();
        long generationstamp = this.namenode.nextGenerationStamp(block, closeFile);
        Block newblock = new Block(block.getBlockId(), block.getNumBytes(), generationstamp);
        for (BlockRecord r : syncList) {
            try {
                r.datanode.updateBlock(r.info.getBlock(), newblock, closeFile);
                successList.add(r.id);
            }
            catch (IOException e) {
                InterDatanodeProtocol.LOG.warn((Object)("Failed to updateBlock (newblock=" + newblock + ", datanode=" + r.id + ")"), (Throwable)e);
            }
        }
        if (!successList.isEmpty()) {
            DatanodeID[] nlist = successList.toArray(new DatanodeID[successList.size()]);
            this.namenode.commitBlockSynchronization(block, newblock.getGenerationStamp(), newblock.getNumBytes(), closeFile, false, nlist);
            DatanodeInfo[] info = new DatanodeInfo[nlist.length];
            for (int i = 0; i < nlist.length; ++i) {
                info[i] = new DatanodeInfo(nlist[i]);
            }
            LocatedBlock b = new LocatedBlock(newblock, info);
            if (this.isBlockTokenEnabled) {
                b.setBlockToken(this.blockTokenSecretManager.generateToken(null, b.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
            }
            return b;
        }
        StringBuilder b = new StringBuilder();
        for (BlockRecord r : syncList) {
            b.append("\n  " + r.id);
        }
        throw new IOException("Cannot recover " + block + ", none of these " + syncList.size() + " datanodes success {" + b + "\n}");
    }

    @Override
    public LocatedBlock recoverBlock(Block block, boolean keepLength, DatanodeInfo[] targets) throws IOException {
        DataNode.logRecoverBlock("Client", block, targets);
        this.checkBlockToken(block, BlockTokenSecretManager.AccessMode.WRITE);
        return this.recoverBlock(block, keepLength, targets, false);
    }

    @Override
    public Block getBlockInfo(Block block) throws IOException {
        this.checkBlockToken(block, BlockTokenSecretManager.AccessMode.READ);
        Block stored = this.data.getStoredBlock(block.getBlockId());
        return stored;
    }

    private static void logRecoverBlock(String who, Block block, DatanodeID[] targets) {
        StringBuilder msg = new StringBuilder(targets[0].getName());
        for (int i = 1; i < targets.length; ++i) {
            msg.append(", " + targets[i].getName());
        }
        LOG.info((Object)(who + " calls recoverBlock(block=" + block + ", targets=[" + msg + "])"));
    }

    public static InetSocketAddress getStreamingAddr(Configuration conf) {
        String address = NetUtils.getServerAddress(conf, "dfs.datanode.bindAddress", "dfs.datanode.port", "dfs.datanode.address");
        return NetUtils.createSocketAddr(address);
    }

    @Override
    public String getHostName() {
        return this.machineName;
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public String getRpcPort() {
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr(this.getConf().get("dfs.datanode.ipc.address"));
        return Integer.toString(ipcAddr.getPort());
    }

    @Override
    public String getHttpPort() {
        return this.getConf().get("dfs.datanode.info.port");
    }

    @Override
    public String getNamenodeAddress() {
        return nameNodeAddr.getHostName();
    }

    @Override
    public String getVolumeInfo() {
        HashMap info = new HashMap();
        Collection<FSDataset.VolumeInfo> volumes = ((FSDataset)this.data).getVolumeInfo();
        for (FSDataset.VolumeInfo v : volumes) {
            HashMap<String, Long> innerInfo = new HashMap<String, Long>();
            innerInfo.put("usedSpace", v.usedSpace);
            innerInfo.put("freeSpace", v.freeSpace);
            innerInfo.put("reservedSpace", v.reservedSpace);
            info.put(v.directory, innerInfo);
        }
        return JSON.toString(info);
    }

    public Long getBalancerBandwidth() {
        DataXceiverServer dxcs = (DataXceiverServer)this.dataXceiverServer.getRunnable();
        return dxcs.balanceThrottler.getBandwidth();
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        ClientTraceLog = LogFactory.getLog((String)(DataNode.class.getName() + ".clienttrace"));
        datanodeObject = null;
        R = new Random();
    }

    private static class BlockRecord {
        final DatanodeID id;
        final InterDatanodeProtocol datanode;
        final BlockRecoveryInfo info;

        BlockRecord(DatanodeID id, InterDatanodeProtocol datanode, BlockRecoveryInfo info) {
            this.id = id;
            this.datanode = datanode;
            this.info = info;
        }

        public String toString() {
            return "BlockRecord(info=" + this.info + " node=" + this.id + ")";
        }
    }

    class DataTransfer
    implements Runnable {
        DatanodeInfo[] targets;
        Block b;
        DataNode datanode;

        public DataTransfer(DatanodeInfo[] targets, Block b, DataNode datanode) throws IOException {
            this.targets = targets;
            this.b = b;
            this.datanode = datanode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                DataNode.this.xmitsInProgress.getAndIncrement();
                Socket sock = null;
                DataOutputStream out = null;
                BlockSender blockSender = null;
                try {
                    InetSocketAddress curTarget = NetUtils.createSocketAddr(this.targets[0].getName());
                    sock = DataNode.this.newSocket();
                    NetUtils.connect(sock, curTarget, DataNode.this.socketTimeout);
                    sock.setSoTimeout(this.targets.length * DataNode.this.socketTimeout);
                    long writeTimeout = DataNode.this.socketWriteTimeout + 5000 * (this.targets.length - 1);
                    OutputStream baseStream = NetUtils.getOutputStream(sock, writeTimeout);
                    out = new DataOutputStream(new BufferedOutputStream(baseStream, FSConstants.SMALL_BUFFER_SIZE));
                    blockSender = new BlockSender(this.b, 0L, this.b.getNumBytes(), false, false, false, this.datanode);
                    DatanodeInfo srcNode = new DatanodeInfo(DataNode.this.dnRegistration);
                    out.writeShort(17);
                    out.writeByte(80);
                    out.writeLong(this.b.getBlockId());
                    out.writeLong(this.b.getGenerationStamp());
                    out.writeInt(0);
                    out.writeBoolean(false);
                    Text.writeString(out, DataNode.EMPTY_DEL_HINT);
                    out.writeBoolean(true);
                    srcNode.write(out);
                    out.writeInt(this.targets.length - 1);
                    for (int i = 1; i < this.targets.length; ++i) {
                        this.targets[i].write(out);
                    }
                    Token<BlockTokenIdentifier> accessToken = BlockTokenSecretManager.DUMMY_TOKEN;
                    if (DataNode.this.isBlockTokenEnabled) {
                        accessToken = DataNode.this.blockTokenSecretManager.generateToken(null, this.b, EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE));
                    }
                    accessToken.write(out);
                    blockSender.sendBlock(out, baseStream, null);
                    LOG.info((Object)(DataNode.this.dnRegistration + ":Transmitted block " + this.b + " to " + curTarget));
                    DataNode.this.xmitsInProgress.getAndDecrement();
                }
                catch (IOException ie) {
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":Failed to transfer " + this.b + " to " + this.targets[0].getName() + " got " + StringUtils.stringifyException(ie)));
                    this.datanode.checkDiskError();
                    break block7;
                }
                finally {
                    DataNode.this.xmitsInProgress.getAndDecrement();
                    IOUtils.closeStream(blockSender);
                    IOUtils.closeStream(out);
                    IOUtils.closeSocket(sock);
                }
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeSocket(sock);
            }
        }
    }
}

