/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.web.resources;

import com.sun.jersey.spi.container.ResourceFilters;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.ParamFilter;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UriFsPathParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@Path(value="")
@ResourceFilters(value={ParamFilter.class})
public class NamenodeWebHdfsMethods {
    public static final Log LOG = LogFactory.getLog(NamenodeWebHdfsMethods.class);
    private static final UriFsPathParam ROOT = new UriFsPathParam("");
    private static final ThreadLocal<String> REMOTE_ADDRESS = new ThreadLocal();
    @Context
    private ServletContext context;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public static String getRemoteAddress() {
        return REMOTE_ADDRESS.get();
    }

    private void init(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, UriFsPathParam path, HttpOpParam<?> op, Param<?, ?> ... parameters) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HTTP " + (Object)((Object)((HttpOpParam.Op)((Object)((Enum)op.getValue()))).getType()) + ": " + op + ", " + path + ", ugi=" + ugi + ", " + username + ", " + doAsUser + Param.toSortedString(", ", parameters)));
        }
        this.response.setContentType(null);
    }

    private static DatanodeInfo chooseDatanode(NameNode namenode, String path, HttpOpParam.Op op, long openOffset) throws IOException {
        if (op == GetOpParam.Op.OPEN || op == GetOpParam.Op.GETFILECHECKSUM || op == PostOpParam.Op.APPEND) {
            long offset;
            LocatedBlocks locations;
            int count;
            HdfsFileStatus status = namenode.getFileInfo(path);
            if (status == null) {
                throw new FileNotFoundException("File " + path + " not found.");
            }
            long len = status.getLen();
            if (op == GetOpParam.Op.OPEN && (openOffset < 0L || openOffset >= len && len > 0L)) {
                throw new IOException("Offset=" + openOffset + " out of the range [0, " + len + "); " + op + ", path=" + path);
            }
            if (len > 0L && (count = (locations = namenode.getBlockLocations(path, offset = op == GetOpParam.Op.OPEN ? openOffset : len - 1L, 1L)).locatedBlockCount()) > 0) {
                return JspHelper.bestNode(locations.get(0));
            }
        }
        return namenode.getNamesystem().getRandomDatanode();
    }

    private Token<? extends TokenIdentifier> generateDelegationToken(NameNode namenode, UserGroupInformation ugi, String renewer) throws IOException {
        Credentials c = DelegationTokenSecretManager.createCredentials(namenode, ugi, renewer != null ? renewer : ugi.getShortUserName());
        Token<? extends TokenIdentifier> t = c.getAllTokens().iterator().next();
        t.setKind(WebHdfsFileSystem.TOKEN_KIND);
        SecurityUtil.setTokenService(t, namenode.getHttpAddress());
        return t;
    }

    private URI redirectURI(NameNode namenode, UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String path, HttpOpParam.Op op, long openOffset, Param<?, ?> ... parameters) throws URISyntaxException, IOException {
        String delegationQuery;
        DatanodeInfo dn = NamenodeWebHdfsMethods.chooseDatanode(namenode, path, op, openOffset);
        if (!UserGroupInformation.isSecurityEnabled()) {
            delegationQuery = Param.toSortedString("&", doAsUser, username);
        } else if (delegation.getValue() != null) {
            delegationQuery = "&" + delegation;
        } else {
            Token<? extends TokenIdentifier> t = this.generateDelegationToken(namenode, ugi, this.request.getUserPrincipal().getName());
            delegationQuery = "&" + new DelegationParam(t.encodeToUrlString());
        }
        String query = op.toQueryString() + delegationQuery + Param.toSortedString("&", parameters);
        String uripath = "/webhdfs/v1" + path;
        URI uri = new URI("http", null, dn.getHostName(), dn.getInfoPort(), uripath, query, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("redirectURI=" + uri));
        }
        return uri;
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response putRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, @QueryParam(value="destination") @DefaultValue(value="") DestinationParam destination, @QueryParam(value="owner") @DefaultValue(value="") OwnerParam owner, @QueryParam(value="group") @DefaultValue(value="") GroupParam group, @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize, @QueryParam(value="modificationtime") @DefaultValue(value="-1") ModificationTimeParam modificationTime, @QueryParam(value="accesstime") @DefaultValue(value="-1") AccessTimeParam accessTime, @QueryParam(value="token") @DefaultValue(value="") TokenArgumentParam delegationTokenArgument) throws IOException, InterruptedException {
        return this.put(ugi, delegation, username, doAsUser, ROOT, op, destination, owner, group, permission, overwrite, bufferSize, replication, blockSize, modificationTime, accessTime, delegationTokenArgument);
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response put(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, final @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, final @QueryParam(value="destination") @DefaultValue(value="") DestinationParam destination, final @QueryParam(value="owner") @DefaultValue(value="") OwnerParam owner, final @QueryParam(value="group") @DefaultValue(value="") GroupParam group, final @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, final @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, final @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, final @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize, final @QueryParam(value="modificationtime") @DefaultValue(value="-1") ModificationTimeParam modificationTime, final @QueryParam(value="accesstime") @DefaultValue(value="-1") AccessTimeParam accessTime, final @QueryParam(value="token") @DefaultValue(value="") TokenArgumentParam delegationTokenArgument) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, op, destination, owner, group, permission, overwrite, bufferSize, replication, blockSize, modificationTime, accessTime, delegationTokenArgument);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException, URISyntaxException {
                REMOTE_ADDRESS.set(NamenodeWebHdfsMethods.this.request.getRemoteAddr());
                try {
                    String fullpath = path.getAbsolutePath();
                    Configuration conf = (Configuration)NamenodeWebHdfsMethods.this.context.getAttribute("current.conf");
                    NameNode namenode = (NameNode)NamenodeWebHdfsMethods.this.context.getAttribute("name.node");
                    switch ((PutOpParam.Op)op.getValue()) {
                        case CREATE: {
                            URI uri = NamenodeWebHdfsMethods.this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, new Param[]{permission, overwrite, bufferSize, replication, blockSize});
                            Response response = Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                            return response;
                        }
                        case MKDIRS: {
                            boolean b = namenode.mkdirs(fullpath, permission.getFsPermission());
                            String js = JsonUtil.toJsonString("boolean", (Object)b);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case RENAME: {
                            boolean b = namenode.rename(fullpath, (String)destination.getValue());
                            String js = JsonUtil.toJsonString("boolean", (Object)b);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case SETREPLICATION: {
                            boolean b = namenode.setReplication(fullpath, replication.getValue(conf));
                            String js = JsonUtil.toJsonString("boolean", (Object)b);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case SETOWNER: {
                            if (owner.getValue() == null && group.getValue() == null) {
                                throw new IllegalArgumentException("Both owner and group are empty.");
                            }
                            namenode.setOwner(fullpath, (String)owner.getValue(), (String)group.getValue());
                            Response b = Response.ok().type("application/octet-stream").build();
                            return b;
                        }
                        case SETPERMISSION: {
                            namenode.setPermission(fullpath, permission.getFsPermission());
                            Response b = Response.ok().type("application/octet-stream").build();
                            return b;
                        }
                        case SETTIMES: {
                            namenode.setTimes(fullpath, (Long)modificationTime.getValue(), (Long)accessTime.getValue());
                            Response b = Response.ok().type("application/octet-stream").build();
                            return b;
                        }
                        case RENEWDELEGATIONTOKEN: {
                            Token<DelegationTokenIdentifier> token = new Token<DelegationTokenIdentifier>();
                            token.decodeFromUrlString((String)delegationTokenArgument.getValue());
                            long expiryTime = namenode.renewDelegationToken(token);
                            String js = JsonUtil.toJsonString("long", (Object)expiryTime);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case CANCELDELEGATIONTOKEN: {
                            Token<DelegationTokenIdentifier> token = new Token<DelegationTokenIdentifier>();
                            token.decodeFromUrlString((String)delegationTokenArgument.getValue());
                            namenode.cancelDelegationToken(token);
                            Response response = Response.ok().type("application/octet-stream").build();
                            return response;
                        }
                    }
                    throw new UnsupportedOperationException(op + " is not supported");
                }
                finally {
                    REMOTE_ADDRESS.set(null);
                }
            }
        });
    }

    @POST
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response postRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        return this.post(ugi, delegation, username, doAsUser, ROOT, op, bufferSize);
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response post(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, final @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, op, bufferSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException, URISyntaxException {
                REMOTE_ADDRESS.set(NamenodeWebHdfsMethods.this.request.getRemoteAddr());
                try {
                    String fullpath = path.getAbsolutePath();
                    NameNode namenode = (NameNode)NamenodeWebHdfsMethods.this.context.getAttribute("name.node");
                    switch ((PostOpParam.Op)op.getValue()) {
                        case APPEND: {
                            URI uri = NamenodeWebHdfsMethods.this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, new Param[]{bufferSize});
                            Response response = Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                            return response;
                        }
                    }
                    throw new UnsupportedOperationException(op + " is not supported");
                }
                finally {
                    REMOTE_ADDRESS.set(null);
                }
            }
        });
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response getRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, @QueryParam(value="renewer") @DefaultValue(value="null") RenewerParam renewer, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, URISyntaxException, InterruptedException {
        return this.get(ugi, delegation, username, doAsUser, ROOT, op, offset, length, renewer, bufferSize);
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response get(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, final @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, final @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, final @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, final @QueryParam(value="renewer") @DefaultValue(value="null") RenewerParam renewer, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, op, offset, length, renewer, bufferSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException, URISyntaxException {
                REMOTE_ADDRESS.set(NamenodeWebHdfsMethods.this.request.getRemoteAddr());
                try {
                    NameNode namenode = (NameNode)NamenodeWebHdfsMethods.this.context.getAttribute("name.node");
                    String fullpath = path.getAbsolutePath();
                    switch ((GetOpParam.Op)op.getValue()) {
                        case OPEN: {
                            URI uri = NamenodeWebHdfsMethods.this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), (Long)offset.getValue(), new Param[]{offset, length, bufferSize});
                            Response response = Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                            return response;
                        }
                        case GET_BLOCK_LOCATIONS: {
                            long offsetValue = (Long)offset.getValue();
                            Long lengthValue = (Long)length.getValue();
                            LocatedBlocks locatedblocks = namenode.getBlockLocations(fullpath, offsetValue, lengthValue != null ? lengthValue : Long.MAX_VALUE);
                            String js = JsonUtil.toJsonString(locatedblocks);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case GETFILESTATUS: {
                            HdfsFileStatus status = namenode.getFileInfo(fullpath);
                            if (status == null) {
                                throw new FileNotFoundException("File does not exist: " + fullpath);
                            }
                            String js = JsonUtil.toJsonString(status, true);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case LISTSTATUS: {
                            StreamingOutput streaming = NamenodeWebHdfsMethods.getListingStream(namenode, fullpath);
                            Response js = Response.ok((Object)streaming).type("application/json").build();
                            return js;
                        }
                        case GETCONTENTSUMMARY: {
                            ContentSummary contentsummary = namenode.getContentSummary(fullpath);
                            String js = JsonUtil.toJsonString(contentsummary);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case GETFILECHECKSUM: {
                            URI uri = NamenodeWebHdfsMethods.this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, new Param[0]);
                            Response js = Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                            return js;
                        }
                        case GETDELEGATIONTOKEN: {
                            if (delegation.getValue() != null) {
                                throw new IllegalArgumentException(delegation.getName() + " parameter is not null.");
                            }
                            Token token = NamenodeWebHdfsMethods.this.generateDelegationToken(namenode, ugi, (String)renewer.getValue());
                            String js = JsonUtil.toJsonString(token);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                        case GETHOMEDIRECTORY: {
                            String js = JsonUtil.toJsonString(org.apache.hadoop.fs.Path.class.getSimpleName(), (Object)WebHdfsFileSystem.getHomeDirectoryString(ugi));
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                    }
                    throw new UnsupportedOperationException(op + " is not supported");
                }
                finally {
                    REMOTE_ADDRESS.set(null);
                }
            }
        });
    }

    private static DirectoryListing getDirectoryListing(NameNode np, String p, byte[] startAfter) throws IOException {
        DirectoryListing listing = np.getListing(p, startAfter);
        if (listing == null) {
            throw new FileNotFoundException("File " + p + " does not exist.");
        }
        return listing;
    }

    private static StreamingOutput getListingStream(final NameNode np, final String p) throws IOException {
        final DirectoryListing first = NamenodeWebHdfsMethods.getDirectoryListing(np, p, HdfsFileStatus.EMPTY_NAME);
        return new StreamingOutput(){

            public void write(OutputStream outstream) throws IOException {
                PrintStream out = new PrintStream(outstream);
                out.println("{\"" + FileStatus.class.getSimpleName() + "es\":{\"" + FileStatus.class.getSimpleName() + "\":[");
                HdfsFileStatus[] partial = first.getPartialListing();
                if (partial.length > 0) {
                    out.print(JsonUtil.toJsonString(partial[0], false));
                }
                for (int i = 1; i < partial.length; ++i) {
                    out.println(',');
                    out.print(JsonUtil.toJsonString(partial[i], false));
                }
                DirectoryListing curr = first;
                while (curr.hasMore()) {
                    curr = NamenodeWebHdfsMethods.getDirectoryListing(np, p, curr.getLastName());
                    for (HdfsFileStatus s : curr.getPartialListing()) {
                        out.println(',');
                        out.print(JsonUtil.toJsonString(s, false));
                    }
                }
                out.println();
                out.println("]}}");
            }
        };
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response deleteRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") DeleteOpParam op, @QueryParam(value="recursive") @DefaultValue(value="false") RecursiveParam recursive) throws IOException, InterruptedException {
        return this.delete(ugi, delegation, username, doAsUser, ROOT, op, recursive);
    }

    @DELETE
    @Path(value="{path:.*}")
    @Produces(value={"application/json"})
    public Response delete(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") DeleteOpParam op, final @QueryParam(value="recursive") @DefaultValue(value="false") RecursiveParam recursive) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, op, recursive);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException {
                REMOTE_ADDRESS.set(NamenodeWebHdfsMethods.this.request.getRemoteAddr());
                try {
                    NameNode namenode = (NameNode)NamenodeWebHdfsMethods.this.context.getAttribute("name.node");
                    String fullpath = path.getAbsolutePath();
                    switch ((DeleteOpParam.Op)op.getValue()) {
                        case DELETE: {
                            boolean b = namenode.delete(fullpath, (Boolean)recursive.getValue());
                            String js = JsonUtil.toJsonString("boolean", (Object)b);
                            Response response = Response.ok((Object)js).type("application/json").build();
                            return response;
                        }
                    }
                    throw new UnsupportedOperationException(op + " is not supported");
                }
                finally {
                    REMOTE_ADDRESS.set(null);
                }
            }
        });
    }
}

