/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.HistoryEventEmitter;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.tools.rumen.SingleEventEmitter;
import org.apache.hadoop.tools.rumen.TaskAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptStartedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.tools.rumen.Version20LogInterfaceUtils;

public abstract class TaskAttempt20LineEventEmitter
extends HistoryEventEmitter {
    static List<SingleEventEmitter> taskEventNonFinalSEEs = new LinkedList<SingleEventEmitter>();
    static List<SingleEventEmitter> taskEventFinalSEEs = new LinkedList<SingleEventEmitter>();
    private static final int DEFAULT_HTTP_PORT = 80;
    Long originalStartTime = null;
    TaskType originalTaskType = null;

    protected TaskAttempt20LineEventEmitter() {
    }

    static {
        taskEventNonFinalSEEs.add(new TaskAttemptStartedEventEmitter());
        taskEventNonFinalSEEs.add(new TaskAttemptFinishedEventEmitter());
        taskEventNonFinalSEEs.add(new TaskAttemptUnsuccessfulCompletionEventEmitter());
    }

    private static class TaskAttemptUnsuccessfulCompletionEventEmitter
    extends SingleEventEmitter {
        private TaskAttemptUnsuccessfulCompletionEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskAttemptIDName, HistoryEventEmitter thatg) {
            if (taskAttemptIDName == null) {
                return null;
            }
            TaskAttemptID taskAttemptID = TaskAttemptID.forName(taskAttemptIDName);
            String finishTime = line.get("FINISH_TIME");
            String status = line.get("TASK_STATUS");
            if (finishTime != null && status != null && !status.equalsIgnoreCase("success")) {
                String hostName = line.get("HOSTNAME");
                String error = line.get("ERROR");
                TaskAttempt20LineEventEmitter that = (TaskAttempt20LineEventEmitter)thatg;
                return new TaskAttemptUnsuccessfulCompletionEvent(taskAttemptID, that.originalTaskType, status, Long.parseLong(finishTime), hostName, error);
            }
            return null;
        }
    }

    private static class TaskAttemptFinishedEventEmitter
    extends SingleEventEmitter {
        private TaskAttemptFinishedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskAttemptIDName, HistoryEventEmitter thatg) {
            if (taskAttemptIDName == null) {
                return null;
            }
            TaskAttemptID taskAttemptID = TaskAttemptID.forName(taskAttemptIDName);
            String finishTime = line.get("FINISH_TIME");
            String status = line.get("TASK_STATUS");
            if (finishTime != null && status != null && status.equalsIgnoreCase("success")) {
                String hostName = line.get("HOSTNAME");
                String counters = line.get("COUNTERS");
                String state = line.get("STATE_STRING");
                TaskAttempt20LineEventEmitter that = (TaskAttempt20LineEventEmitter)thatg;
                return new TaskAttemptFinishedEvent(taskAttemptID, that.originalTaskType, status, Long.parseLong(finishTime), hostName, state, HistoryEventEmitter.maybeParseCounters(counters));
            }
            return null;
        }
    }

    private static class TaskAttemptStartedEventEmitter
    extends SingleEventEmitter {
        private TaskAttemptStartedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskAttemptIDName, HistoryEventEmitter thatg) {
            if (taskAttemptIDName == null) {
                return null;
            }
            TaskAttemptID taskAttemptID = TaskAttemptID.forName(taskAttemptIDName);
            String startTime = line.get("START_TIME");
            String taskType = line.get("TASK_TYPE");
            String trackerName = line.get("TRACKER_NAME");
            String httpPort = line.get("HTTP_PORT");
            if (startTime != null && taskType != null) {
                TaskAttempt20LineEventEmitter that = (TaskAttempt20LineEventEmitter)thatg;
                that.originalStartTime = Long.parseLong(startTime);
                that.originalTaskType = Version20LogInterfaceUtils.get20TaskType(taskType);
                int port = httpPort.equals("") ? 80 : Integer.parseInt(httpPort);
                return new TaskAttemptStartedEvent(taskAttemptID, that.originalTaskType, that.originalStartTime, trackerName, port);
            }
            return null;
        }
    }
}

