/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.TaskAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.tools.rumen.TaskStartedEvent;

public class TopologyBuilder {
    private Set<ParsedHost> allHosts = new HashSet<ParsedHost>();

    public void process(HistoryEvent event) {
        if (event instanceof TaskAttemptFinishedEvent) {
            this.processTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)event);
        } else if (event instanceof TaskAttemptUnsuccessfulCompletionEvent) {
            this.processTaskAttemptUnsuccessfulCompletionEvent((TaskAttemptUnsuccessfulCompletionEvent)event);
        } else if (event instanceof TaskStartedEvent) {
            this.processTaskStartedEvent((TaskStartedEvent)event);
        }
    }

    public void process(Properties conf) {
    }

    public LoggedNetworkTopology build() {
        return new LoggedNetworkTopology(this.allHosts);
    }

    private void processTaskStartedEvent(TaskStartedEvent event) {
        this.preferredLocationForSplits(event.getSplitLocations());
    }

    private void processTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptUnsuccessfulCompletionEvent event) {
        this.recordParsedHost(event.getHostname());
    }

    private void processTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        this.recordParsedHost(event.getHostname());
    }

    private void recordParsedHost(String hostName) {
        ParsedHost result = ParsedHost.parse(hostName);
        if (result != null && !this.allHosts.contains(result)) {
            this.allHosts.add(result);
        }
    }

    private void preferredLocationForSplits(String splits) {
        if (splits != null) {
            StringTokenizer tok = new StringTokenizer(splits, ",", false);
            while (tok.hasMoreTokens()) {
                String nextSplit = tok.nextToken();
                this.recordParsedHost(nextSplit);
            }
        }
    }
}

