/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.jaas;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.utils.properties.Properties;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.client.ZKData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperProperties
extends Properties
implements LifecycleListener,
Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperProperties.class);
    protected String path;
    protected IZKClient zooKeeper;
    private CountDownLatch connectedLatch = new CountDownLatch(1);
    private boolean connected = false;

    public ZookeeperProperties(IZKClient zooKeeper, String path) throws Exception {
        this.path = path;
        this.zooKeeper = zooKeeper;
        this.zooKeeper.registerListener((LifecycleListener)this);
        this.connectedLatch.await(1L, TimeUnit.SECONDS);
    }

    @Override
    public void save() throws IOException {
        StringWriter writer = new StringWriter();
        this.saveLayout(writer);
        try {
            this.zooKeeper.setData(this.path, writer.toString());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void process(WatchedEvent watchedEvent) {
        if (watchedEvent.getType() == Watcher.Event.EventType.NodeDataChanged || watchedEvent.getType() == Watcher.Event.EventType.NodeDeleted) {
            try {
                this.fetchData();
            }
            catch (Exception e) {
                LOG.warn("failed refreshing authentication data", (Throwable)e);
            }
        }
    }

    protected void fetchData() throws Exception {
        ZKData zkData = this.zooKeeper.getZKStringData(this.path, (Watcher)this);
        String value = (String)zkData.getData();
        if (value != null) {
            this.clear();
            this.load(new StringReader(value));
        }
    }

    public void onConnected() {
        try {
            if (!this.connected) {
                this.fetchData();
                this.connected = true;
                this.connectedLatch.countDown();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed initializing authentication plugin", (Throwable)e);
        }
    }

    public void onDisconnected() {
        this.connected = false;
    }
}

