/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.jolokia.converter.object.OpenTypeConverter;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TabularDataConverter
extends OpenTypeConverter<TabularType> {
    public TabularDataConverter(OpenTypeConverter pDispatcher) {
        super(pDispatcher);
    }

    @Override
    boolean canConvert(OpenType pType) {
        return pType instanceof TabularType;
    }

    @Override
    Object convertToObject(TabularType pType, Object pFrom) {
        JSONAware pValue = this.toJSON(pFrom);
        CompositeType rowType = pType.getRowType();
        if (rowType.containsKey("key") && rowType.containsKey("value") && rowType.keySet().size() == 2) {
            return this.convertToTabularTypeFromMap(pType, pValue, rowType);
        }
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        if (!(pValue instanceof JSONObject)) {
            throw new IllegalArgumentException("Expected JSON type for a TabularData is JSONObject, not " + pValue.getClass());
        }
        this.putRowsToTabularData(tabularData, (JSONObject)pValue, pType.getIndexNames().size());
        return tabularData;
    }

    private void putRowsToTabularData(TabularDataSupport pTabularData, JSONObject pValue, int pLevel) {
        TabularType type = pTabularData.getTabularType();
        for (Object value : pValue.values()) {
            if (!(value instanceof JSONObject)) {
                throw new IllegalArgumentException("Cannot convert " + pValue + " to type " + type + " because the object values provided (" + value.getClass() + ") is not of the expected type JSONObject at level " + pLevel);
            }
            JSONObject jsonValue = (JSONObject)value;
            if (pLevel > 1) {
                this.putRowsToTabularData(pTabularData, jsonValue, pLevel - 1);
                continue;
            }
            pTabularData.put((CompositeData)this.getDispatcher().convertToObject(type.getRowType(), jsonValue));
        }
    }

    private TabularData convertToTabularTypeFromMap(TabularType pType, JSONAware pValue, CompositeType pRowType) {
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        if (!(pValue instanceof JSONObject)) {
            throw new IllegalArgumentException("Cannot convert " + pValue + " to a TabularData type for an MXBean's map representation. " + "This must be a JSONObject / Map");
        }
        Map jsonObj = (Map)((Object)pValue);
        for (Map.Entry entry : jsonObj.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.getDispatcher().convertToObject(pRowType.getType("key"), entry.getKey()));
            map.put("value", this.getDispatcher().convertToObject(pRowType.getType("value"), entry.getValue()));
            try {
                CompositeDataSupport compositeData = new CompositeDataSupport(pRowType, map);
                tabularData.put(compositeData);
            }
            catch (OpenDataException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return tabularData;
    }
}

