/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import org.rrd4j.core.Util;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;

class ValueAxis
implements RrdGraphConstants {
    private static final YLabel[] ylabels = new YLabel[]{new YLabel(0.1, 1, 2, 5, 10), new YLabel(0.2, 1, 5, 10, 20), new YLabel(0.5, 1, 2, 4, 10), new YLabel(1.0, 1, 2, 5, 10), new YLabel(2.0, 1, 5, 10, 20), new YLabel(5.0, 1, 2, 4, 10), new YLabel(10.0, 1, 2, 5, 10), new YLabel(20.0, 1, 5, 10, 20), new YLabel(50.0, 1, 2, 4, 10), new YLabel(100.0, 1, 2, 5, 10), new YLabel(200.0, 1, 5, 10, 20), new YLabel(500.0, 1, 2, 4, 10), new YLabel(1000.0, 1, 2, 5, 10), new YLabel(2000.0, 1, 5, 10, 20), new YLabel(5000.0, 1, 2, 4, 10), new YLabel(10000.0, 1, 2, 5, 10), new YLabel(20000.0, 1, 5, 10, 20), new YLabel(50000.0, 1, 2, 4, 10), new YLabel(100000.0, 1, 2, 5, 10), new YLabel(0.0, 0, 0, 0, 0)};
    private RrdGraph rrdGraph;
    private ImageParameters im;
    private ImageWorker worker;
    private RrdGraphDef gdef;

    ValueAxis(RrdGraph rrdGraph) {
        this.rrdGraph = rrdGraph;
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
    }

    boolean draw() {
        double gridstep;
        Font font = this.gdef.smallFont;
        Paint gridColor = this.gdef.colors[4];
        Paint mGridColor = this.gdef.colors[5];
        Paint fontColor = this.gdef.colors[6];
        int fontHeight = (int)Math.ceil(this.rrdGraph.getSmallFontHeight());
        int labelOffset = (int)(this.worker.getFontAscent(font) / 2.0);
        int labfact = 2;
        int gridind = -1;
        double range = this.im.maxval - this.im.minval;
        double scaledrange = range / this.im.magfact;
        if (Double.isNaN(scaledrange)) {
            return false;
        }
        int pixel = 1;
        String labfmt = null;
        if (Double.isNaN(this.im.ygridstep)) {
            if (this.gdef.altYGrid) {
                int fractionals;
                int decimals = (int)Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                if (decimals <= 0) {
                    decimals = 1;
                }
                labfmt = (fractionals = (int)Math.floor(Math.log10(range))) < 0 ? Util.sprintf("%%%d.%df", decimals - fractionals + 1, -fractionals + 1) : Util.sprintf("%%%d.1f", decimals + 1);
                gridstep = Math.pow(10.0, fractionals);
                if (gridstep == 0.0) {
                    gridstep = 0.1;
                }
                if (range / gridstep < 5.0) {
                    gridstep /= 10.0;
                }
                if (range / gridstep > 15.0) {
                    gridstep *= 10.0;
                }
                if (range / gridstep > 5.0) {
                    labfact = 1;
                    if (range / gridstep > 8.0) {
                        labfact = 2;
                    }
                } else {
                    gridstep /= 5.0;
                    labfact = 5;
                }
            } else {
                int i = 0;
                while (ValueAxis.ylabels[i].grid > 0.0) {
                    pixel = (int)((double)this.im.ysize / (scaledrange / ValueAxis.ylabels[i].grid));
                    if (gridind == -1 && pixel > 5) {
                        gridind = i;
                        break;
                    }
                    ++i;
                }
                if (gridind == -1) {
                    gridind = 0;
                }
                for (i = 0; i < 4; ++i) {
                    if (pixel * ValueAxis.ylabels[gridind].labelFacts[i] < 2 * fontHeight) continue;
                    labfact = ValueAxis.ylabels[gridind].labelFacts[i];
                    break;
                }
                gridstep = ValueAxis.ylabels[gridind].grid * this.im.magfact;
            }
        } else {
            gridstep = this.im.ygridstep;
            labfact = this.im.ylabfact;
        }
        int x0 = this.im.xorigin;
        int x1 = x0 + this.im.xsize;
        int sgrid = (int)(this.im.minval / gridstep - 1.0);
        int egrid = (int)(this.im.maxval / gridstep + 1.0);
        double scaledstep = gridstep / this.im.magfact;
        for (int i = sgrid; i <= egrid; ++i) {
            int y = this.rrdGraph.mapper.ytr(gridstep * (double)i);
            if (y < this.im.yorigin - this.im.ysize || y > this.im.yorigin) continue;
            if (i % labfact == 0) {
                String graph_label = i == 0 || this.im.symbol == ' ' ? (scaledstep < 1.0 ? (i != 0 && this.gdef.altYGrid ? Util.sprintf(labfmt, scaledstep * (double)i) : Util.sprintf("%4.1f", scaledstep * (double)i)) : Util.sprintf("%4.0f", scaledstep * (double)i)) : (scaledstep < 1.0 ? Util.sprintf("%4.1f %c", scaledstep * (double)i, Character.valueOf(this.im.symbol)) : Util.sprintf("%4.0f %c", scaledstep * (double)i, Character.valueOf(this.im.symbol)));
                int length = (int)this.worker.getStringWidth(graph_label, font);
                this.worker.drawString(graph_label, x0 - length - 7, y + labelOffset, font, fontColor);
                this.worker.drawLine(x0 - 2, y, x0 + 2, y, mGridColor, TICK_STROKE);
                this.worker.drawLine(x1 - 2, y, x1 + 2, y, mGridColor, TICK_STROKE);
                this.worker.drawLine(x0, y, x1, y, mGridColor, GRID_STROKE);
                continue;
            }
            if (this.gdef.noMinorGrid) continue;
            this.worker.drawLine(x0 - 1, y, x0 + 1, y, gridColor, TICK_STROKE);
            this.worker.drawLine(x1 - 1, y, x1 + 1, y, gridColor, TICK_STROKE);
            this.worker.drawLine(x0, y, x1, y, gridColor, GRID_STROKE);
        }
        return true;
    }

    static class YLabel {
        final double grid;
        final int[] labelFacts;

        YLabel(double grid, int lfac1, int lfac2, int lfac3, int lfac4) {
            this.grid = grid;
            this.labelFacts = new int[]{lfac1, lfac2, lfac3, lfac4};
        }
    }
}

