/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum WriteConsistencyLevel {
    DEFAULT(0),
    ONE(1),
    QUORUM(2),
    ALL(3);

    private final byte id;

    private WriteConsistencyLevel(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static WriteConsistencyLevel fromId(byte value) {
        if (value == 0) {
            return DEFAULT;
        }
        if (value == 1) {
            return ONE;
        }
        if (value == 2) {
            return QUORUM;
        }
        if (value == 3) {
            return ALL;
        }
        throw new ElasticSearchIllegalArgumentException("No write consistency match [" + value + "]");
    }

    public static WriteConsistencyLevel fromString(String value) {
        if (value.equals("default")) {
            return DEFAULT;
        }
        if (value.equals("one")) {
            return ONE;
        }
        if (value.equals("quorum")) {
            return QUORUM;
        }
        if (value.equals("all")) {
            return ALL;
        }
        throw new ElasticSearchIllegalArgumentException("No write consistency match [" + value + "]");
    }
}

