/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.monitor.network.NetworkStats;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.transport.TransportStats;

public class NodeStats
extends NodeOperationResponse {
    private NodeIndicesStats indices;
    private OsStats os;
    private ProcessStats process;
    private JvmStats jvm;
    private NetworkStats network;
    private TransportStats transport;

    NodeStats() {
    }

    public NodeStats(DiscoveryNode node, NodeIndicesStats indices, OsStats os, ProcessStats process, JvmStats jvm, NetworkStats network, TransportStats transport) {
        super(node);
        this.indices = indices;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.network = network;
        this.transport = transport;
    }

    public NodeIndicesStats indices() {
        return this.indices;
    }

    public NodeIndicesStats getIndices() {
        return this.indices();
    }

    public OsStats os() {
        return this.os;
    }

    public OsStats getOs() {
        return this.os();
    }

    public ProcessStats process() {
        return this.process;
    }

    public ProcessStats getProcess() {
        return this.process();
    }

    public JvmStats jvm() {
        return this.jvm;
    }

    public JvmStats getJvm() {
        return this.jvm();
    }

    public NetworkStats network() {
        return this.network;
    }

    public NetworkStats getNetwork() {
        return this.network();
    }

    public TransportStats transport() {
        return this.transport;
    }

    public TransportStats getTransport() {
        return this.transport();
    }

    public static NodeStats readNodeStats(StreamInput in) throws IOException {
        NodeStats nodeInfo = new NodeStats();
        nodeInfo.readFrom(in);
        return nodeInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.indices = NodeIndicesStats.readIndicesStats(in);
        }
        if (in.readBoolean()) {
            this.os = OsStats.readOsStats(in);
        }
        if (in.readBoolean()) {
            this.process = ProcessStats.readProcessStats(in);
        }
        if (in.readBoolean()) {
            this.jvm = JvmStats.readJvmStats(in);
        }
        if (in.readBoolean()) {
            this.network = NetworkStats.readNetworkStats(in);
        }
        if (in.readBoolean()) {
            this.transport = TransportStats.readTransportStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indices.writeTo(out);
        }
        if (this.os == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.os.writeTo(out);
        }
        if (this.process == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.process.writeTo(out);
        }
        if (this.jvm == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.jvm.writeTo(out);
        }
        if (this.network == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.network.writeTo(out);
        }
        if (this.transport == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.transport.writeTo(out);
        }
    }
}

