/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.search.ShardSearchFailure;

public class SearchPhaseExecutionException
extends ElasticSearchException {
    private final String phaseName;
    private ShardSearchFailure[] shardFailures;

    public SearchPhaseExecutionException(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        super(SearchPhaseExecutionException.buildMessage(phaseName, msg, shardFailures));
        this.phaseName = phaseName;
        this.shardFailures = shardFailures;
    }

    public SearchPhaseExecutionException(String phaseName, String msg, Throwable cause, ShardSearchFailure[] shardFailures) {
        super(SearchPhaseExecutionException.buildMessage(phaseName, msg, shardFailures), cause);
        this.phaseName = phaseName;
        this.shardFailures = shardFailures;
    }

    public String phaseName() {
        return this.phaseName;
    }

    public ShardSearchFailure[] shardFailures() {
        return this.shardFailures;
    }

    private static String buildMessage(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to execute phase [").append(phaseName).append("], ").append(msg);
        if (shardFailures != null && shardFailures.length > 0) {
            sb.append("; shardFailures ");
            for (ShardSearchFailure shardFailure : shardFailures) {
                if (shardFailure.shard() != null) {
                    sb.append("{").append(shardFailure.shard()).append(": ").append(shardFailure.reason()).append("}");
                    continue;
                }
                sb.append("{").append(shardFailure.reason()).append("}");
            }
        }
        return sb.toString();
    }
}

