/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.NodeAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ConcurrentRebalanceNodeAllocation
extends NodeAllocation {
    private final int clusterConcurrentRebalance;

    @Inject
    public ConcurrentRebalanceNodeAllocation(Settings settings) {
        super(settings);
        this.clusterConcurrentRebalance = this.componentSettings.getAsInt("cluster_concurrent_rebalance", 2);
        this.logger.debug("using [cluster_concurrent_rebalance] with [{}]", this.clusterConcurrentRebalance);
    }

    @Override
    public boolean canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (this.clusterConcurrentRebalance == -1) {
            return true;
        }
        int rebalance = 0;
        for (RoutingNode node : allocation.routingNodes()) {
            for (MutableShardRouting shard : node) {
                if (shard.state() != ShardRoutingState.RELOCATING) continue;
                ++rebalance;
            }
        }
        return rebalance < this.clusterConcurrentRebalance;
    }
}

