/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import org.elasticsearch.common.thread.ThreadLocals;

public class Bytes {
    public static final ThreadLocal<ThreadLocals.CleanableValue<byte[]>> cachedBytes = new ThreadLocal<ThreadLocals.CleanableValue<byte[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<byte[]> initialValue() {
            return new ThreadLocals.CleanableValue<byte[]>(new byte[1024]);
        }
    };
    public static final byte[] EMPTY_ARRAY = new byte[0];
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] LONG_MIN_VALUE_BYTES = "-9223372036854775808".getBytes();
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static byte[] itoa(int i) {
        int size = i < 0 ? Bytes.stringSize(-i) + 1 : Bytes.stringSize(i);
        byte[] buf = new byte[size];
        Bytes.getChars(i, size, buf);
        return buf;
    }

    static void getChars(int i, int index, byte[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static int atoi(byte[] s) throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int i = 0;
        int len = s.length;
        int limit = -2147483647;
        if (len > 0) {
            byte firstChar = s[0];
            if (firstChar < 48) {
                if (firstChar != 45) {
                    throw new NumberFormatException();
                }
                negative = true;
                limit = Integer.MIN_VALUE;
                if (len == 1) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            int multmin = limit / 10;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s[i++], 10)) < 0) {
                    throw new NumberFormatException();
                }
                if (result < multmin) {
                    throw new NumberFormatException();
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException();
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException();
        }
        return negative ? result : -result;
    }

    public static byte[] ltoa(long i) {
        if (i == Long.MIN_VALUE) {
            return LONG_MIN_VALUE_BYTES;
        }
        int size = i < 0L ? Bytes.stringSize(-i) + 1 : Bytes.stringSize(i);
        byte[] buf = new byte[size];
        Bytes.getChars(i, size, buf);
        return buf;
    }

    static void getChars(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static long atol(byte[] s) throws NumberFormatException {
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length;
        long limit = -9223372036854775807L;
        if (len > 0) {
            byte firstChar = s[0];
            if (firstChar < 48) {
                if (firstChar != 45) {
                    throw new NumberFormatException();
                }
                negative = true;
                limit = Long.MIN_VALUE;
                if (len == 1) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            long multmin = limit / 10L;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s[i++], 10)) < 0) {
                    throw new NumberFormatException();
                }
                if (result < multmin) {
                    throw new NumberFormatException();
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException();
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException();
        }
        return negative ? result : -result;
    }
}

