/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.Writer;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.util.concurrent.NotThreadSafe;

@NotThreadSafe
public class StringBuilderWriter
extends Writer {
    private final StringBuilder builder;

    public StringBuilderWriter() {
        this.builder = new StringBuilder();
    }

    public StringBuilderWriter(int capacity) {
        this.builder = new StringBuilder(capacity);
    }

    public StringBuilderWriter(StringBuilder builder) {
        this.builder = builder != null ? builder : new StringBuilder();
    }

    @Override
    public Writer append(char value) {
        this.builder.append(value);
        return this;
    }

    @Override
    public Writer append(CharSequence value) {
        this.builder.append(value);
        return this;
    }

    @Override
    public Writer append(CharSequence value, int start, int end) {
        this.builder.append(value, start, end);
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(String value) {
        if (value != null) {
            this.builder.append(value);
        }
    }

    @Override
    public void write(char[] value, int offset, int length) {
        if (value != null) {
            this.builder.append(value, offset, length);
        }
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public String toString() {
        return this.builder.toString();
    }

    public static class Cached {
        private static final ThreadLocal<ThreadLocals.CleanableValue<StringBuilderWriter>> cache = new ThreadLocal<ThreadLocals.CleanableValue<StringBuilderWriter>>(){

            @Override
            protected ThreadLocals.CleanableValue<StringBuilderWriter> initialValue() {
                return new ThreadLocals.CleanableValue<StringBuilderWriter>(new StringBuilderWriter());
            }
        };

        public static StringBuilderWriter cached() {
            StringBuilderWriter writer = cache.get().get();
            writer.getBuilder().setLength(0);
            return writer;
        }
    }
}

