/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.index.ExtendedIndexSearcher;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.lease.Releasable;

public class ReaderSearcherHolder
implements Releasable {
    private final ExtendedIndexSearcher indexSearcher;

    public ReaderSearcherHolder(IndexReader indexReader) {
        this(new ExtendedIndexSearcher(indexReader));
    }

    public ReaderSearcherHolder(ExtendedIndexSearcher indexSearcher) {
        this.indexSearcher = indexSearcher;
    }

    public IndexReader reader() {
        return this.indexSearcher.getIndexReader();
    }

    public ExtendedIndexSearcher searcher() {
        return this.indexSearcher;
    }

    @Override
    public boolean release() throws ElasticSearchException {
        try {
            this.indexSearcher.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.indexSearcher.getIndexReader().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

