/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.BoostFieldMapper;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FailedToGenerateSourceMapperException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.mapper.UidFieldMapper;
import org.elasticsearch.index.mapper.xcontent.AllFieldMapper;
import org.elasticsearch.index.mapper.xcontent.AnalyzerMapper;
import org.elasticsearch.index.mapper.xcontent.BoostFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ContentPath;
import org.elasticsearch.index.mapper.xcontent.IdFieldMapper;
import org.elasticsearch.index.mapper.xcontent.IndexFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParentFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.RootObjectMapper;
import org.elasticsearch.index.mapper.xcontent.RoutingFieldMapper;
import org.elasticsearch.index.mapper.xcontent.SizeFieldMapper;
import org.elasticsearch.index.mapper.xcontent.SourceFieldMapper;
import org.elasticsearch.index.mapper.xcontent.TypeFieldMapper;
import org.elasticsearch.index.mapper.xcontent.UidFieldMapper;
import org.elasticsearch.index.mapper.xcontent.XContentDocumentMapperParser;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class XContentDocumentMapper
implements DocumentMapper,
ToXContent {
    private ThreadLocal<ThreadLocals.CleanableValue<ParseContext>> cache = new ThreadLocal<ThreadLocals.CleanableValue<ParseContext>>(){

        @Override
        protected ThreadLocals.CleanableValue<ParseContext> initialValue() {
            return new ThreadLocals.CleanableValue<ParseContext>(new ParseContext(XContentDocumentMapper.this.index, XContentDocumentMapper.this.docMapperParser, XContentDocumentMapper.this, new ContentPath(0)));
        }
    };
    private final String index;
    private final String type;
    private final XContentDocumentMapperParser docMapperParser;
    private volatile ImmutableMap<String, Object> meta;
    private volatile CompressedString mappingSource;
    private final org.elasticsearch.index.mapper.xcontent.UidFieldMapper uidFieldMapper;
    private final org.elasticsearch.index.mapper.xcontent.IdFieldMapper idFieldMapper;
    private final org.elasticsearch.index.mapper.xcontent.TypeFieldMapper typeFieldMapper;
    private final IndexFieldMapper indexFieldMapper;
    private final org.elasticsearch.index.mapper.xcontent.SourceFieldMapper sourceFieldMapper;
    private final SizeFieldMapper sizeFieldMapper;
    private final RoutingFieldMapper routingFieldMapper;
    private final ParentFieldMapper parentFieldMapper;
    private final org.elasticsearch.index.mapper.xcontent.BoostFieldMapper boostFieldMapper;
    private final AllFieldMapper allFieldMapper;
    private final AnalyzerMapper analyzerMapper;
    private final RootObjectMapper rootObjectMapper;
    private final NamedAnalyzer indexAnalyzer;
    private final NamedAnalyzer searchAnalyzer;
    private volatile DocumentFieldMappers fieldMappers;
    private final List<FieldMapperListener> fieldMapperListeners = Lists.newArrayList();
    private final Filter typeFilter;
    private final Object mutex = new Object();

    public XContentDocumentMapper(String index, XContentDocumentMapperParser docMapperParser, RootObjectMapper rootObjectMapper, ImmutableMap<String, Object> meta, org.elasticsearch.index.mapper.xcontent.UidFieldMapper uidFieldMapper, org.elasticsearch.index.mapper.xcontent.IdFieldMapper idFieldMapper, org.elasticsearch.index.mapper.xcontent.TypeFieldMapper typeFieldMapper, IndexFieldMapper indexFieldMapper, org.elasticsearch.index.mapper.xcontent.SourceFieldMapper sourceFieldMapper, SizeFieldMapper sizeFieldMapper, @Nullable ParentFieldMapper parentFieldMapper, RoutingFieldMapper routingFieldMapper, AllFieldMapper allFieldMapper, AnalyzerMapper analyzerMapper, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, @Nullable org.elasticsearch.index.mapper.xcontent.BoostFieldMapper boostFieldMapper) {
        this.index = index;
        this.type = rootObjectMapper.name();
        this.docMapperParser = docMapperParser;
        this.meta = meta;
        this.rootObjectMapper = rootObjectMapper;
        this.uidFieldMapper = uidFieldMapper;
        this.idFieldMapper = idFieldMapper;
        this.typeFieldMapper = typeFieldMapper;
        this.indexFieldMapper = indexFieldMapper;
        this.sourceFieldMapper = sourceFieldMapper;
        this.sizeFieldMapper = sizeFieldMapper;
        this.parentFieldMapper = parentFieldMapper;
        this.routingFieldMapper = routingFieldMapper;
        this.allFieldMapper = allFieldMapper;
        this.analyzerMapper = analyzerMapper;
        this.boostFieldMapper = boostFieldMapper;
        this.indexAnalyzer = indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer;
        this.typeFilter = this.typeMapper().fieldFilter(this.type);
        rootObjectMapper.putMapper(idFieldMapper);
        if (boostFieldMapper != null) {
            rootObjectMapper.putMapper(boostFieldMapper);
        }
        if (parentFieldMapper != null) {
            rootObjectMapper.putMapper(parentFieldMapper);
            routingFieldMapper.markAsRequired();
        }
        rootObjectMapper.putMapper(routingFieldMapper);
        final ArrayList<FieldMapper> tempFieldMappers = Lists.newArrayList();
        if (indexFieldMapper.enabled()) {
            tempFieldMappers.add(indexFieldMapper);
        }
        tempFieldMappers.add(typeFieldMapper);
        tempFieldMappers.add(sourceFieldMapper);
        tempFieldMappers.add(sizeFieldMapper);
        tempFieldMappers.add(uidFieldMapper);
        tempFieldMappers.add(allFieldMapper);
        rootObjectMapper.traverse(new FieldMapperListener(){

            @Override
            public void fieldMapper(FieldMapper fieldMapper) {
                tempFieldMappers.add(fieldMapper);
            }
        });
        this.fieldMappers = new DocumentFieldMappers(this, tempFieldMappers);
        this.refreshSource();
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ImmutableMap<String, Object> meta() {
        return this.meta;
    }

    @Override
    public CompressedString mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.rootObjectMapper;
    }

    @Override
    public UidFieldMapper uidMapper() {
        return this.uidFieldMapper;
    }

    @Override
    public IdFieldMapper idMapper() {
        return this.idFieldMapper;
    }

    @Override
    public org.elasticsearch.index.mapper.IndexFieldMapper indexMapper() {
        return this.indexFieldMapper;
    }

    @Override
    public TypeFieldMapper typeMapper() {
        return this.typeFieldMapper;
    }

    @Override
    public SourceFieldMapper sourceMapper() {
        return this.sourceFieldMapper;
    }

    @Override
    public BoostFieldMapper boostMapper() {
        return this.boostFieldMapper;
    }

    @Override
    public org.elasticsearch.index.mapper.AllFieldMapper allFieldMapper() {
        return this.allFieldMapper;
    }

    @Override
    public org.elasticsearch.index.mapper.RoutingFieldMapper routingFieldMapper() {
        return this.routingFieldMapper;
    }

    @Override
    public org.elasticsearch.index.mapper.ParentFieldMapper parentFieldMapper() {
        return this.parentFieldMapper;
    }

    @Override
    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    public Filter typeFilter() {
        return this.typeFilter;
    }

    @Override
    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    @Override
    public ParsedDocument parse(byte[] source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source));
    }

    @Override
    public ParsedDocument parse(String type, String id, byte[] source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source).type(type).id(id));
    }

    @Override
    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.parse(source, null);
    }

    @Override
    public ParsedDocument parse(SourceToParse source, @Nullable DocumentMapper.ParseListener listener) throws MapperParsingException {
        ParseContext context = this.cache.get().get();
        if (source.type() != null && !source.type().equals(this.type)) {
            throw new MapperParsingException("Type mismatch, provide type [" + source.type() + "] but mapper is of type [" + this.type + "]");
        }
        source.type(this.type);
        XContentParser parser = source.parser();
        try {
            if (parser == null) {
                if (LZF.isCompressed(source.source())) {
                    BytesStreamInput siBytes = new BytesStreamInput(source.source());
                    LZFStreamInput siLzf = CachedStreamInput.cachedLzf(siBytes);
                    XContentType contentType = XContentFactory.xContentType(siLzf);
                    siLzf.resetToBufferStart();
                    parser = XContentFactory.xContent(contentType).createParser(siLzf);
                } else {
                    parser = XContentFactory.xContent(source.source()).createParser(source.source());
                }
            }
            context.reset(parser, new Document(), this.type, source.source(), source.flyweight(), listener);
            int countDownTokens = 0;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new MapperParsingException("Malformed content, must start with an object");
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
            }
            if (parser.currentName().equals(this.type)) {
                token = parser.nextToken();
                ++countDownTokens;
            }
            if (this.sizeFieldMapper.enabled()) {
                context.externalValue(source.source().length);
                this.sizeFieldMapper.parse(context);
            }
            if (this.sourceFieldMapper.enabled()) {
                this.sourceFieldMapper.parse(context);
            }
            if (source.id() != null) {
                context.id(source.id());
                this.uidFieldMapper.parse(context);
            }
            this.typeFieldMapper.parse(context);
            if (source.routing() != null) {
                context.externalValue(source.routing());
                this.routingFieldMapper.parse(context);
            }
            this.indexFieldMapper.parse(context);
            this.rootObjectMapper.parse(context);
            for (int i = 0; i < countDownTokens; ++i) {
                parser.nextToken();
            }
            if (source.id() == null) {
                if (context.id() == null) {
                    if (!source.flyweight()) {
                        throw new MapperParsingException("No id found while parsing the content source");
                    }
                } else {
                    this.uidFieldMapper.parse(context);
                }
            }
            if (context.parsedIdState() != ParseContext.ParsedIdState.PARSED) {
                if (context.id() == null) {
                    if (!source.flyweight()) {
                        throw new MapperParsingException("No id mapping with [_id] found in the content, and not explicitly set");
                    }
                } else {
                    context.parsedId(ParseContext.ParsedIdState.EXTERNAL);
                    this.idFieldMapper.parse(context);
                }
            }
            if (this.parentFieldMapper != null) {
                context.externalValue(source.parent());
                this.parentFieldMapper.parse(context);
            }
            this.analyzerMapper.parse(context);
            this.allFieldMapper.parse(context);
            this.routingFieldMapper.validate(context, source.routing());
        }
        catch (IOException e) {
            throw new MapperParsingException("Failed to parse", e);
        }
        finally {
            if (source.parser() == null && parser != null) {
                parser.close();
            }
        }
        ParsedDocument doc = new ParsedDocument(context.uid(), context.id(), context.type(), source.routing(), context.doc(), context.analyzer(), context.source(), context.mappersAdded()).parent(source.parent());
        context.reset(null, null, null, null, false, null);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFieldMapper(FieldMapper fieldMapper) {
        Object object = this.mutex;
        synchronized (object) {
            this.fieldMappers = this.fieldMappers.concat((DocumentMapper)this, fieldMapper);
            for (FieldMapperListener listener : this.fieldMapperListeners) {
                listener.fieldMapper(fieldMapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFieldMapperListener(FieldMapperListener fieldMapperListener, boolean includeExisting) {
        Object object = this.mutex;
        synchronized (object) {
            this.fieldMapperListeners.add(fieldMapperListener);
            if (includeExisting) {
                if (this.indexFieldMapper.enabled()) {
                    fieldMapperListener.fieldMapper(this.indexFieldMapper);
                }
                fieldMapperListener.fieldMapper(this.sourceFieldMapper);
                fieldMapperListener.fieldMapper(this.sizeFieldMapper);
                fieldMapperListener.fieldMapper(this.typeFieldMapper);
                fieldMapperListener.fieldMapper(this.uidFieldMapper);
                fieldMapperListener.fieldMapper(this.allFieldMapper);
                this.rootObjectMapper.traverse(fieldMapperListener);
            }
        }
    }

    @Override
    public synchronized DocumentMapper.MergeResult merge(DocumentMapper mergeWith, DocumentMapper.MergeFlags mergeFlags) {
        XContentDocumentMapper xContentMergeWith = (XContentDocumentMapper)mergeWith;
        MergeContext mergeContext = new MergeContext(this, mergeFlags);
        this.rootObjectMapper.merge(xContentMergeWith.rootObjectMapper, mergeContext);
        this.allFieldMapper.merge(xContentMergeWith.allFieldMapper, mergeContext);
        this.analyzerMapper.merge(xContentMergeWith.analyzerMapper, mergeContext);
        this.sourceFieldMapper.merge(xContentMergeWith.sourceFieldMapper, mergeContext);
        this.sizeFieldMapper.merge(xContentMergeWith.sizeFieldMapper, mergeContext);
        if (!mergeFlags.simulate()) {
            this.meta = mergeWith.meta();
            this.refreshSource();
        }
        return new DocumentMapper.MergeResult(mergeContext.buildConflicts());
    }

    @Override
    public void refreshSource() throws FailedToGenerateSourceMapperException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            this.mappingSource = new CompressedString(builder.string());
        }
        catch (Exception e) {
            throw new FailedToGenerateSourceMapperException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        this.rootObjectMapper.close();
        this.idFieldMapper.close();
        this.indexFieldMapper.close();
        this.typeFieldMapper.close();
        this.allFieldMapper.close();
        this.analyzerMapper.close();
        this.sourceFieldMapper.close();
        this.sizeFieldMapper.close();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.rootObjectMapper.toXContent(builder, params, new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (XContentDocumentMapper.this.indexAnalyzer != null && XContentDocumentMapper.this.searchAnalyzer != null && XContentDocumentMapper.this.indexAnalyzer.name().equals(XContentDocumentMapper.this.searchAnalyzer.name()) && !XContentDocumentMapper.this.indexAnalyzer.name().startsWith("_")) {
                    if (!XContentDocumentMapper.this.indexAnalyzer.name().equals("default")) {
                        builder.field("analyzer", XContentDocumentMapper.this.indexAnalyzer.name());
                    }
                } else {
                    if (XContentDocumentMapper.this.indexAnalyzer != null && !XContentDocumentMapper.this.indexAnalyzer.name().startsWith("_") && !XContentDocumentMapper.this.indexAnalyzer.name().equals("default")) {
                        builder.field("index_analyzer", XContentDocumentMapper.this.indexAnalyzer.name());
                    }
                    if (XContentDocumentMapper.this.searchAnalyzer != null && !XContentDocumentMapper.this.searchAnalyzer.name().startsWith("_") && !XContentDocumentMapper.this.searchAnalyzer.name().equals("default")) {
                        builder.field("search_analyzer", XContentDocumentMapper.this.searchAnalyzer.name());
                    }
                }
                if (XContentDocumentMapper.this.meta != null && !XContentDocumentMapper.this.meta.isEmpty()) {
                    builder.field("_meta", XContentDocumentMapper.this.meta());
                }
                return builder;
            }
        }, this.indexFieldMapper, this.typeFieldMapper, this.allFieldMapper, this.analyzerMapper, this.sourceFieldMapper, this.sizeFieldMapper);
        return builder;
    }

    public static class Builder {
        private org.elasticsearch.index.mapper.xcontent.UidFieldMapper uidFieldMapper = new org.elasticsearch.index.mapper.xcontent.UidFieldMapper();
        private org.elasticsearch.index.mapper.xcontent.IdFieldMapper idFieldMapper = new org.elasticsearch.index.mapper.xcontent.IdFieldMapper();
        private org.elasticsearch.index.mapper.xcontent.TypeFieldMapper typeFieldMapper = new org.elasticsearch.index.mapper.xcontent.TypeFieldMapper();
        private IndexFieldMapper indexFieldMapper = new IndexFieldMapper();
        private org.elasticsearch.index.mapper.xcontent.SourceFieldMapper sourceFieldMapper = new org.elasticsearch.index.mapper.xcontent.SourceFieldMapper();
        private SizeFieldMapper sizeFieldMapper = new SizeFieldMapper();
        private RoutingFieldMapper routingFieldMapper = new RoutingFieldMapper();
        private org.elasticsearch.index.mapper.xcontent.BoostFieldMapper boostFieldMapper = new org.elasticsearch.index.mapper.xcontent.BoostFieldMapper();
        private AllFieldMapper allFieldMapper = new AllFieldMapper();
        private AnalyzerMapper analyzerMapper = new AnalyzerMapper();
        private ParentFieldMapper parentFieldMapper = null;
        private NamedAnalyzer indexAnalyzer;
        private NamedAnalyzer searchAnalyzer;
        private final String index;
        private final RootObjectMapper rootObjectMapper;
        private ImmutableMap<String, Object> meta = ImmutableMap.of();
        private XContentMapper.BuilderContext builderContext = new XContentMapper.BuilderContext(new ContentPath(1));

        public Builder(String index, @Nullable Settings indexSettings, RootObjectMapper.Builder builder) {
            String idIndexed;
            this.index = index;
            this.rootObjectMapper = (RootObjectMapper)builder.build(this.builderContext);
            if (indexSettings != null && (idIndexed = indexSettings.get("index.mapping._id.indexed")) != null && Booleans.parseBoolean(idIndexed, false)) {
                this.idFieldMapper = new org.elasticsearch.index.mapper.xcontent.IdFieldMapper(Field.Index.NOT_ANALYZED);
            }
        }

        public Builder meta(ImmutableMap<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder sourceField(SourceFieldMapper.Builder builder) {
            this.sourceFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder sizeField(SizeFieldMapper.Builder builder) {
            this.sizeFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder idField(IdFieldMapper.Builder builder) {
            this.idFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder uidField(UidFieldMapper.Builder builder) {
            this.uidFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder typeField(TypeFieldMapper.Builder builder) {
            this.typeFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder indexField(IndexFieldMapper.Builder builder) {
            this.indexFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder routingField(RoutingFieldMapper.Builder builder) {
            this.routingFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder parentFiled(ParentFieldMapper.Builder builder) {
            this.parentFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder boostField(BoostFieldMapper.Builder builder) {
            this.boostFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder allField(AllFieldMapper.Builder builder) {
            this.allFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder analyzerField(AnalyzerMapper.Builder builder) {
            this.analyzerMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        public boolean hasIndexAnalyzer() {
            return this.indexAnalyzer != null;
        }

        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            return this;
        }

        public boolean hasSearchAnalyzer() {
            return this.searchAnalyzer != null;
        }

        public XContentDocumentMapper build(XContentDocumentMapperParser docMapperParser) {
            Preconditions.checkNotNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            return new XContentDocumentMapper(this.index, docMapperParser, this.rootObjectMapper, this.meta, this.uidFieldMapper, this.idFieldMapper, this.typeFieldMapper, this.indexFieldMapper, this.sourceFieldMapper, this.sizeFieldMapper, this.parentFieldMapper, this.routingFieldMapper, this.allFieldMapper, this.analyzerMapper, this.indexAnalyzer, this.searchAnalyzer, this.boostFieldMapper);
        }
    }
}

