/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class MergeStats
implements Streamable,
ToXContent {
    private long total;
    private long current;
    private long totalTimeInMillis;

    public MergeStats() {
    }

    public MergeStats(long total, long current, long totalTimeInMillis) {
        this.total = total;
        this.current = current;
        this.totalTimeInMillis = totalTimeInMillis;
    }

    public void add(long totalMerges, long currentMerges, long totalMergeTime) {
        this.total += totalMerges;
        this.current += currentMerges;
        this.totalTimeInMillis += totalMergeTime;
    }

    public void add(MergeStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.total += mergeStats.total;
        this.current += mergeStats.current;
        this.totalTimeInMillis += mergeStats.totalTimeInMillis;
    }

    public long total() {
        return this.total;
    }

    public long current() {
        return this.current;
    }

    public long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue totalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public static MergeStats readMergeStats(StreamInput in) throws IOException {
        MergeStats stats = new MergeStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.MERGES);
        builder.field(Fields.CURRENT, this.current);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.TOTAL_TIME, this.totalTime().toString());
        builder.field(Fields.TOTAL_TIME_IN_MILLIS, this.totalTimeInMillis);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.current = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.current);
        out.writeVLong(this.totalTimeInMillis);
    }

    static final class Fields {
        static final XContentBuilderString MERGES = new XContentBuilderString("merges");
        static final XContentBuilderString CURRENT = new XContentBuilderString("current");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_TIME = new XContentBuilderString("total_time");
        static final XContentBuilderString TOTAL_TIME_IN_MILLIS = new XContentBuilderString("total_time_in_millis");

        Fields() {
        }
    }
}

