/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.search.geo.GeoBoundingBoxFilter;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.settings.IndexSettings;

public class GeoBoundingBoxFilterParser
extends AbstractIndexComponent
implements XContentFilterParser {
    public static final String NAME = "geo_bbox";

    @Inject
    public GeoBoundingBoxFilterParser(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoBbox", "geo_bounding_box", "geoBoundingBox"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        String fieldName = null;
        GeoBoundingBoxFilter.Point topLeft = new GeoBoundingBoxFilter.Point();
        GeoBoundingBoxFilter.Point bottomRight = new GeoBoundingBoxFilter.Point();
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    GeoBoundingBoxFilter.Point point;
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        point = null;
                        if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                            point = topLeft;
                        } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                            point = bottomRight;
                        }
                        if (point == null) continue;
                        token = parser.nextToken();
                        point.lon = parser.doubleValue();
                        token = parser.nextToken();
                        point.lat = parser.doubleValue();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        }
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        point = null;
                        if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                            point = topLeft;
                        } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                            point = bottomRight;
                        }
                        if (point == null) continue;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if (currentFieldName.equals("lat")) {
                                point.lat = parser.doubleValue();
                                continue;
                            }
                            if (currentFieldName.equals("lon")) {
                                point.lon = parser.doubleValue();
                                continue;
                            }
                            if (!currentFieldName.equals("geohash")) continue;
                            double[] values = GeoHashUtils.decode(parser.text());
                            point.lat = values[0];
                            point.lon = values[1];
                        }
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if ("field".equals(currentFieldName)) {
                        fieldName = parser.text();
                        continue;
                    }
                    point = null;
                    if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                        point = topLeft;
                    } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                        point = bottomRight;
                    }
                    if (point == null) continue;
                    String value = parser.text();
                    int comma = value.indexOf(44);
                    if (comma != -1) {
                        point.lat = Double.parseDouble(value.substring(0, comma).trim());
                        point.lon = Double.parseDouble(value.substring(comma + 1).trim());
                        continue;
                    }
                    double[] values = GeoHashUtils.decode(value);
                    point.lat = values[0];
                    point.lon = values[1];
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if (!"_cache".equals(currentFieldName)) continue;
            cache = parser.booleanValue();
        }
        MapperService mapperService = parseContext.mapperService();
        FieldMapper mapper = mapperService.smartNameFieldMapper(fieldName);
        if (mapper == null) {
            throw new QueryParsingException(this.index, "failed to find geo_point field [" + fieldName + "]");
        }
        if (mapper.fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new QueryParsingException(this.index, "field [" + fieldName + "] is not a geo_point field");
        }
        fieldName = mapper.names().indexName();
        Filter filter = new GeoBoundingBoxFilter(topLeft, bottomRight, fieldName, parseContext.indexCache().fieldData());
        if (cache) {
            filter = parseContext.cacheFilter(filter);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, parseContext.smartFieldMappers(fieldName), parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

